/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import java.io.File;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class BranchMerger
implements IMerger {
    private final SvnVcs myVcs;
    private final String myTargetPath;
    private final SVNURL mySourceUrl;
    private final SVNURL myTargetUrl;
    private final UpdateEventHandler myHandler;
    private final boolean myReintegrate;
    private final String myBranchName;
    private final long mySourceCopyRevision;
    private boolean myAtStart;
    private long mySourceLatestRevision;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BranchMerger(SvnVcs vcs, SVNURL sourceUrl, SVNURL targetUrl, String targetPath, UpdateEventHandler handler, boolean isReintegrate, String branchName, long sourceCopyRevision) {
        this.myVcs = vcs;
        this.myTargetPath = targetPath;
        this.mySourceUrl = sourceUrl;
        this.myTargetUrl = targetUrl;
        this.myHandler = handler;
        this.myReintegrate = isReintegrate;
        this.myBranchName = branchName;
        this.mySourceCopyRevision = sourceCopyRevision;
        this.myAtStart = true;
        SVNRepository repository = null;
        try {
            repository = this.myVcs.createRepository(this.mySourceUrl);
            this.mySourceLatestRevision = repository.getLatestRevision();
        }
        catch (SVNException e) {
            this.mySourceLatestRevision = SVNRevision.HEAD.getNumber();
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
    }

    @Override
    public String getComment() {
        return "Merge all from " + this.myBranchName + " at " + this.mySourceLatestRevision + (this.myReintegrate ? " (reintegration)" : "");
    }

    @Override
    public boolean hasNext() {
        return this.myAtStart;
    }

    @Override
    public void mergeNext() throws SVNException, VcsException {
        this.myAtStart = false;
        File destination = new File(this.myTargetPath);
        MergeClient client = this.myVcs.getFactory(destination).createMergeClient();
        if (this.myReintegrate) {
            client.merge(SvnTarget.fromURL((SVNURL)this.mySourceUrl), destination, false, this.createDiffOptions(), this.myHandler);
        } else {
            client.merge(SvnTarget.fromURL((SVNURL)this.mySourceUrl, (SVNRevision)SVNRevision.create((long)this.mySourceCopyRevision)), SvnTarget.fromURL((SVNURL)this.mySourceUrl, (SVNRevision)SVNRevision.create((long)this.mySourceLatestRevision)), destination, SVNDepth.INFINITY, true, false, false, true, this.createDiffOptions(), this.myHandler);
        }
    }

    private SVNDiffOptions createDiffOptions() {
        return this.myVcs.getSvnConfiguration().getMergeOptions();
    }

    @Override
    public void getInfo(Consumer<String> holder, boolean getLatest) {
    }

    @Override
    public File getMergeInfoHolder() {
        return new File(this.myTargetPath);
    }

    @Override
    public void afterProcessing() {
    }

    @Override
    public void getSkipped(Consumer<String> holder) {
    }
}

