/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.copy;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.CommitEventHandler;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnCommitRunner;
import org.jetbrains.idea.svn.copy.CopyMoveClient;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdCopyMoveClient
extends BaseSvnClient
implements CopyMoveClient {
    @Override
    public void copy(@NotNull File src, @NotNull File dst, boolean makeParents, boolean isMove) throws VcsException {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/copy/CmdCopyMoveClient", "copy"));
        }
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/copy/CmdCopyMoveClient", "copy"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, src);
        CommandUtil.put(parameters, dst, false);
        CommandUtil.put(parameters, makeParents, "--parents");
        File workingDirectory = isMove && !SystemInfo.isFileSystemCaseSensitive && FileUtil.filesEqual((File)src, (File)dst) ? CommandUtil.getHomeDirectory() : null;
        CommandUtil.execute(this.myVcs, SvnTarget.fromFile((File)dst), workingDirectory, isMove ? SvnCommandName.move : SvnCommandName.copy, parameters, null);
    }

    @Override
    public long copy(@NotNull SvnTarget source, @NotNull SvnTarget destination, @Nullable SVNRevision revision, boolean makeParents, @NotNull String message, @Nullable CommitEventHandler handler) throws VcsException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/copy/CmdCopyMoveClient", "copy"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/copy/CmdCopyMoveClient", "copy"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/idea/svn/copy/CmdCopyMoveClient", "copy"));
        }
        if (!destination.isURL()) {
            throw new IllegalArgumentException("Only urls are supported as destination " + destination);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source);
        CommandUtil.put(parameters, destination);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, makeParents, "--parents");
        parameters.add("--message");
        parameters.add(message);
        SvnCommitRunner.CommandListener listener = new SvnCommitRunner.CommandListener(handler);
        if (source.isFile()) {
            listener.setBaseDirectory(source.getFile());
        }
        CommandUtil.execute(this.myVcs, source, SvnCommandName.copy, parameters, listener);
        return listener.getCommittedRevision();
    }

    @Override
    public void copy(@NotNull SvnTarget source, @NotNull File destination, @Nullable SVNRevision revision, boolean makeParents, @Nullable ISVNEventHandler handler) throws VcsException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/copy/CmdCopyMoveClient", "copy"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/copy/CmdCopyMoveClient", "copy"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source);
        CommandUtil.put(parameters, destination);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, makeParents, "--parents");
        File workingDirectory = CommandUtil.getHomeDirectory();
        BaseUpdateCommandListener listener = new BaseUpdateCommandListener(workingDirectory, handler);
        CommandUtil.execute(this.myVcs, source, workingDirectory, SvnCommandName.copy, parameters, listener);
        listener.throwWrappedIfException();
    }
}

