/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class UpdateOutputLineConverter {
    private static final String MERGING = "--- Merging";
    private static final String RECORDING_MERGE_INFO = "--- Recording mergeinfo";
    private static final String UPDATING = "Updating";
    private static final String AT_REVISION = "At revision (\\d+)\\.";
    private static final String UPDATED_TO_REVISION = "Updated to revision (\\d+)\\.";
    private static final String SKIPPED = "Skipped";
    private static final String RESTORED = "Restored";
    private static final String FETCHING_EXTERNAL = "Fetching external";
    private static final String EXTERNAL = "External at (\\d+)\\.";
    private static final String UPDATED_EXTERNAL = "Updated external to revision (\\d+)\\.";
    private static final Pattern ourAtRevision = Pattern.compile("At revision (\\d+)\\.");
    private static final Pattern ourUpdatedToRevision = Pattern.compile("Updated to revision (\\d+)\\.");
    private static final Pattern ourCheckedOutRevision = Pattern.compile("Checked out revision (\\d+)\\.");
    private static final Pattern ourExportedRevision = Pattern.compile("Exported revision (\\d+)\\.");
    private static final Pattern ourExportComplete = Pattern.compile("Export complete\\.");
    private static final Pattern ourExternal = Pattern.compile("External at (\\d+)\\.");
    private static final Pattern ourUpdatedExternal = Pattern.compile("Updated external to revision (\\d+)\\.");
    private static final Pattern ourCheckedOutExternal = Pattern.compile("Checked out external at revision (\\d+)\\.");
    private static final Pattern[] ourCompletePatterns = new Pattern[]{ourAtRevision, ourUpdatedToRevision, ourCheckedOutRevision, ourExportedRevision, ourExternal, ourUpdatedExternal, ourCheckedOutExternal, ourExportComplete};
    private final File myBase;
    private File myCurrentFile;
    private static final Set<Character> ourActions = new HashSet<Character>(Arrays.asList(Character.valueOf('A'), Character.valueOf('D'), Character.valueOf('U'), Character.valueOf('C'), Character.valueOf('G'), Character.valueOf('E'), Character.valueOf('R')));

    public UpdateOutputLineConverter(File base) {
        this.myBase = base;
        this.myCurrentFile = base;
    }

    public SVNEvent convert(String line) {
        if (StringUtil.isEmptyOrSpaces((String)line)) {
            return null;
        }
        if (line.startsWith(MERGING) || line.startsWith(RECORDING_MERGE_INFO)) {
            return null;
        }
        if (line.startsWith(UPDATING)) {
            this.myCurrentFile = this.parseForPath(line);
            return new SVNEvent(this.myCurrentFile, this.myCurrentFile == null ? null : (this.myCurrentFile.isDirectory() ? SVNNodeKind.DIR : SVNNodeKind.FILE), null, -1L, null, null, null, null, SVNEventAction.UPDATE_NONE, SVNEventAction.UPDATE_NONE, null, null, null, null, null);
        }
        if (line.startsWith(RESTORED)) {
            this.myCurrentFile = this.parseForPath(line);
            return new SVNEvent(this.myCurrentFile, this.myCurrentFile == null ? null : (this.myCurrentFile.isDirectory() ? SVNNodeKind.DIR : SVNNodeKind.FILE), null, -1L, null, null, null, null, SVNEventAction.RESTORE, SVNEventAction.RESTORE, null, null, null, null, null);
        }
        if (line.startsWith(SKIPPED)) {
            this.myCurrentFile = this.parseForPath(line);
            String comment = this.parseComment(line);
            return new SVNEvent(this.myCurrentFile, this.myCurrentFile == null ? null : (this.myCurrentFile.isDirectory() ? SVNNodeKind.DIR : SVNNodeKind.FILE), null, -1L, null, null, null, null, SVNEventAction.SKIP, SVNEventAction.SKIP, comment == null ? null : SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_OBSTRUCTED_UPDATE, (String)comment), null, null, null, null);
        }
        if (line.startsWith(FETCHING_EXTERNAL)) {
            this.myCurrentFile = this.parseForPath(line);
            return new SVNEvent(this.myCurrentFile, this.myCurrentFile == null ? null : (this.myCurrentFile.isDirectory() ? SVNNodeKind.DIR : SVNNodeKind.FILE), null, -1L, null, null, null, null, SVNEventAction.UPDATE_EXTERNAL, SVNEventAction.UPDATE_EXTERNAL, null, null, null, null, null);
        }
        for (int i = 0; i < ourCompletePatterns.length; ++i) {
            Pattern pattern = ourCompletePatterns[i];
            long revision = this.matchAndGetRevision(pattern, line);
            if (revision == -1L) continue;
            return new SVNEvent(this.myCurrentFile, this.myCurrentFile == null ? null : (this.myCurrentFile.isDirectory() ? SVNNodeKind.DIR : SVNNodeKind.FILE), null, revision, null, null, null, null, SVNEventAction.UPDATE_COMPLETED, SVNEventAction.UPDATE_COMPLETED, null, null, null, null, null);
        }
        return this.parseNormalString(line);
    }

    @Nullable
    private SVNEvent parseNormalString(String line) {
        if (line.length() < 5) {
            return null;
        }
        char first = line.charAt(0);
        if (' ' != first && !ourActions.contains(Character.valueOf(first))) {
            return null;
        }
        SVNStatusType contentsStatus = CommandUtil.getStatusType(first);
        char second = line.charAt(1);
        SVNStatusType propertiesStatus = CommandUtil.getStatusType(second);
        char lock = line.charAt(2);
        if (' ' != lock && 'B' != lock) {
            return null;
        }
        char treeConflict = line.charAt(3);
        if (' ' != treeConflict && 'C' != treeConflict) {
            return null;
        }
        boolean haveTreeConflict = 'C' == treeConflict;
        String path = line.substring(4).trim();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        File file = this.createFile(path);
        if (SVNStatusType.STATUS_OBSTRUCTED.equals(contentsStatus)) {
            return new SVNEvent(file, file.isDirectory() ? SVNNodeKind.DIR : SVNNodeKind.FILE, null, -1L, contentsStatus, propertiesStatus, null, null, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, SVNEventAction.UPDATE_ADD, null, null, null, null, null);
        }
        SVNEventAction expectedAction = SVNStatusType.STATUS_ADDED.equals(contentsStatus) ? SVNEventAction.UPDATE_ADD : (SVNStatusType.STATUS_DELETED.equals(contentsStatus) ? SVNEventAction.UPDATE_DELETE : SVNEventAction.UPDATE_UPDATE);
        SVNEventAction action = expectedAction;
        if (haveTreeConflict) {
            action = SVNEventAction.TREE_CONFLICT;
        }
        return new SVNEvent(file, file.isDirectory() ? SVNNodeKind.DIR : SVNNodeKind.FILE, null, -1L, contentsStatus, propertiesStatus, null, null, action, expectedAction, null, null, null, null, null);
    }

    private File createFile(String path) {
        return CommandUtil.resolvePath(this.myBase, path);
    }

    @Nullable
    private long matchAndGetRevision(Pattern pattern, String line) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.matches()) {
            if (pattern == ourExportComplete) {
                return 0L;
            }
            String group = matcher.group(1);
            if (group == null) {
                return -1L;
            }
            try {
                return Long.parseLong(group);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return -1L;
    }

    @Nullable
    private String parseComment(String line) {
        int idx = line.lastIndexOf("--");
        if (idx != -1 && idx < line.length() - 2) {
            return line.substring(idx + 2).trim();
        }
        return null;
    }

    @Nullable
    private File parseForPath(String line) {
        int idx1 = line.indexOf(39);
        if (idx1 == -1) {
            return null;
        }
        int idx2 = line.indexOf(39, idx1 + 1);
        if (idx2 == -1) {
            return null;
        }
        String substring = line.substring(idx1 + 1, idx2);
        if (".".equals(substring)) {
            return this.myBase;
        }
        return this.createFile(substring);
    }
}

