/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SVNLockWrapper;
import org.jetbrains.idea.svn.portable.PortableStatus;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SvnStatusHandler
extends DefaultHandler {
    private static final Logger LOG = Logger.getInstance(SvnStatusHandler.class);
    public static final Map<String, SVNStatusType> ourStatusTypes = ContainerUtil.newHashMap();
    private String myChangelistName;
    private List<PortableStatus> myDefaultListStatuses;
    private MultiMap<String, PortableStatus> myCurrentListChanges;
    private PortableStatus myPending;
    private boolean myInRemoteStatus;
    private SVNLockWrapper myLockWrapper;
    private final List<ElementHandlerBase> myParseStack;
    private final Map<String, Getter<ElementHandlerBase>> myElementsMap;
    private final DataCallback myDataCallback;
    private final File myBase;
    private final StringBuilder mySb;
    private boolean myAnythingReported;

    private static void put(SVNStatusType ... statusTypes) {
        if (statusTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnStatusHandler", "put"));
        }
        for (SVNStatusType statusType : statusTypes) {
            SvnStatusHandler.put(statusType);
        }
    }

    private static void put(@NotNull SVNStatusType statusType) {
        if (statusType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnStatusHandler", "put"));
        }
        ourStatusTypes.put(statusType.toString(), statusType);
    }

    @Nullable
    public static SVNStatusType getStatus(@NotNull String code) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnStatusHandler", "getStatus"));
        }
        SVNStatusType result = ourStatusTypes.get(code);
        if (result == null) {
            LOG.info("Unknown status type " + code);
        }
        return result;
    }

    public SvnStatusHandler(final ExternalDataCallback dataCallback, File base, final Convertor<File, SVNInfo> infoGetter) {
        this.myBase = base;
        this.myParseStack = new ArrayList<ElementHandlerBase>();
        this.myParseStack.add(new Fake());
        this.myElementsMap = new HashMap<String, Getter<ElementHandlerBase>>();
        this.fillElements();
        this.myDataCallback = dataCallback != null ? new DataCallback(){

            @Override
            public void startLock() {
                SvnStatusHandler.this.myLockWrapper = new SVNLockWrapper();
            }

            @Override
            public void endLock() {
                if (SvnStatusHandler.this.myInRemoteStatus) {
                    SvnStatusHandler.this.myPending.setRemoteLock(SvnStatusHandler.this.myLockWrapper.create());
                } else {
                    SvnStatusHandler.this.myPending.setLocalLock(SvnStatusHandler.this.myLockWrapper.create());
                }
                SvnStatusHandler.this.myLockWrapper = null;
            }

            @Override
            public void startRemoteStatus() {
                SvnStatusHandler.this.myInRemoteStatus = true;
            }

            @Override
            public void endRemoteStatus() {
                SvnStatusHandler.this.myInRemoteStatus = false;
            }

            @Override
            public void switchPath() {
                SvnStatusHandler.this.myAnythingReported = true;
                dataCallback.switchPath();
                SvnStatusHandler.this.newPending((Convertor<File, SVNInfo>)infoGetter);
            }

            @Override
            public void switchChangeList(String newList) {
                dataCallback.switchChangeList(newList);
            }
        } : new DataCallback(){

            @Override
            public void startLock() {
                SvnStatusHandler.this.myLockWrapper = new SVNLockWrapper();
            }

            @Override
            public void endLock() {
                if (SvnStatusHandler.this.myInRemoteStatus) {
                    SvnStatusHandler.this.myPending.setRemoteLock(SvnStatusHandler.this.myLockWrapper.create());
                } else {
                    SvnStatusHandler.this.myPending.setLocalLock(SvnStatusHandler.this.myLockWrapper.create());
                }
                SvnStatusHandler.this.myLockWrapper = null;
            }

            @Override
            public void startRemoteStatus() {
                SvnStatusHandler.this.myInRemoteStatus = true;
            }

            @Override
            public void endRemoteStatus() {
                SvnStatusHandler.this.myInRemoteStatus = false;
            }

            @Override
            public void switchPath() {
                SvnStatusHandler.this.myAnythingReported = true;
                if (SvnStatusHandler.this.myChangelistName == null) {
                    SvnStatusHandler.this.myDefaultListStatuses.add(SvnStatusHandler.this.myPending);
                } else {
                    SvnStatusHandler.this.myCurrentListChanges.putValue((Object)SvnStatusHandler.this.myChangelistName, (Object)SvnStatusHandler.this.myPending);
                }
                SvnStatusHandler.this.newPending((Convertor<File, SVNInfo>)infoGetter);
            }

            @Override
            public void switchChangeList(String newList) {
                SvnStatusHandler.this.myChangelistName = newList;
            }
        };
        this.newPending(infoGetter);
        this.mySb = new StringBuilder();
    }

    public boolean isAnythingReported() {
        return this.myAnythingReported;
    }

    private void newPending(final Convertor<File, SVNInfo> infoGetter) {
        PortableStatus status;
        this.myPending = status = new PortableStatus();
        status.setInfoGetter(new Getter<SVNInfo>(){

            public SVNInfo get() {
                return (SVNInfo)infoGetter.convert((Object)status.getFile());
            }
        });
    }

    public PortableStatus getPending() {
        return this.myPending;
    }

    public List<PortableStatus> getDefaultListStatuses() {
        return this.myDefaultListStatuses;
    }

    public MultiMap<String, PortableStatus> getCurrentListChanges() {
        return this.myCurrentListChanges;
    }

    private void fillElements() {
        this.myElementsMap.put("repos-status", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new ReposStatus();
            }
        });
        this.myElementsMap.put("lock", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Lock();
            }
        });
        this.myElementsMap.put("token", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new LockToken();
            }
        });
        this.myElementsMap.put("owner", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new LockOwner();
            }
        });
        this.myElementsMap.put("comment", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new LockComment();
            }
        });
        this.myElementsMap.put("created", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new LockCreatedDate();
            }
        });
        this.myElementsMap.put("status", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Status();
            }
        });
        this.myElementsMap.put("author", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Author();
            }
        });
        this.myElementsMap.put("changelist", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Changelist();
            }
        });
        this.myElementsMap.put("commit", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Commit();
            }
        });
        this.myElementsMap.put("date", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Date();
            }
        });
        this.myElementsMap.put("entry", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Entry(SvnStatusHandler.this.myBase);
            }
        });
        this.myElementsMap.put("target", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Target();
            }
        });
        this.myElementsMap.put("against", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Against();
            }
        });
        this.myElementsMap.put("wc-status", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new WcStatus();
            }
        });
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        SvnStatusHandler.assertSAX(!this.myParseStack.isEmpty());
        ElementHandlerBase current = this.myParseStack.get(this.myParseStack.size() - 1);
        if (this.mySb.length() > 0) {
            current.characters(this.mySb.toString().trim(), this.myPending, this.myLockWrapper);
            this.mySb.setLength(0);
        }
        while (true) {
            boolean createNewChild;
            if (createNewChild = current.startElement(uri, localName, qName, attributes)) {
                SvnStatusHandler.assertSAX(this.myElementsMap.containsKey(qName));
                ElementHandlerBase newChild = (ElementHandlerBase)this.myElementsMap.get(qName).get();
                newChild.preAttributesEffect(this.myDataCallback);
                newChild.updateStatus(attributes, this.myPending, this.myLockWrapper);
                newChild.preEffect(this.myDataCallback);
                this.myParseStack.add(newChild);
                return;
            }
            current.postEffect(this.myDataCallback);
            this.myParseStack.remove(this.myParseStack.size() - 1);
            SvnStatusHandler.assertSAX(!this.myParseStack.isEmpty());
            current = this.myParseStack.get(this.myParseStack.size() - 1);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        SvnStatusHandler.assertSAX(!this.myParseStack.isEmpty());
        this.mySb.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        SvnStatusHandler.assertSAX(!this.myParseStack.isEmpty());
        for (int i = this.myParseStack.size() - 1; i >= 0; --i) {
            ElementHandlerBase current = this.myParseStack.get(i);
            current.postEffect(this.myDataCallback);
        }
        this.myParseStack.clear();
    }

    private static void assertSAX(boolean shouldBeTrue) throws SAXException {
        if (!shouldBeTrue) {
            throw new SAXException("can not parse output");
        }
    }

    private static SVNStatusType parseContentsStatus(Attributes attributes) throws SAXException {
        String item = attributes.getValue("item");
        SvnStatusHandler.assertSAX(item != null);
        return SvnStatusHandler.getStatus(item);
    }

    private static SVNStatusType parsePropertiesStatus(Attributes attributes) throws SAXException {
        String props = attributes.getValue("props");
        SvnStatusHandler.assertSAX(props != null);
        return SvnStatusHandler.getStatus(props);
    }

    static {
        SvnStatusHandler.put(SVNStatusType.STATUS_ADDED, SVNStatusType.STATUS_CONFLICTED, SVNStatusType.STATUS_DELETED, SVNStatusType.STATUS_EXTERNAL, SVNStatusType.STATUS_IGNORED, SVNStatusType.STATUS_INCOMPLETE, SVNStatusType.STATUS_MERGED, SVNStatusType.STATUS_MISSING, SVNStatusType.STATUS_MODIFIED, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NORMAL, SVNStatusType.STATUS_OBSTRUCTED, SVNStatusType.STATUS_REPLACED, SVNStatusType.STATUS_UNVERSIONED);
    }

    private static interface DataCallback
    extends ExternalDataCallback {
        public void startRemoteStatus();

        public void endRemoteStatus();

        public void startLock();

        public void endLock();

        @Override
        public void switchPath();

        @Override
        public void switchChangeList(String var1);
    }

    public static interface ExternalDataCallback {
        public void switchPath();

        public void switchChangeList(String var1);
    }

    public static abstract class ElementHandlerBase {
        private final Set<String> myAwaitedChildren;
        private final Set<String> myAwaitedChildrenMultiple;

        ElementHandlerBase(String[] awaitedChildren, String[] awaitedChildrenMultiple) {
            this.myAwaitedChildren = new HashSet<String>(Arrays.asList(awaitedChildren));
            this.myAwaitedChildrenMultiple = new HashSet<String>(Arrays.asList(awaitedChildrenMultiple));
        }

        protected abstract void updateStatus(Attributes var1, PortableStatus var2, SVNLockWrapper var3) throws SAXException;

        public abstract void postEffect(DataCallback var1);

        public abstract void preEffect(DataCallback var1);

        public boolean startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.myAwaitedChildrenMultiple.contains(qName)) {
                return true;
            }
            return this.myAwaitedChildren.remove(qName);
        }

        public abstract void characters(String var1, PortableStatus var2, SVNLockWrapper var3);

        public void preAttributesEffect(DataCallback callback) {
        }
    }

    private static class Status
    extends ElementHandlerBase {
        private Status() {
            super(new String[]{"target"}, new String[]{"changelist"});
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) {
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
        }
    }

    private static class Against
    extends ElementHandlerBase {
        private Against() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
        }
    }

    private static class Target
    extends ElementHandlerBase {
        private Target() {
            super(new String[]{"against"}, new String[]{"entry"});
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) {
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
        }
    }

    private static class Changelist
    extends ElementHandlerBase {
        private String myName;

        private Changelist() {
            super(new String[0], new String[]{"entry"});
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
            String name = attributes.getValue("name");
            SvnStatusHandler.assertSAX(!StringUtil.isEmptyOrSpaces((String)name));
            this.myName = name;
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
            callback.switchChangeList(this.myName);
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
        }
    }

    private static class Entry
    extends ElementHandlerBase {
        private final File myBase;

        private Entry(File base) {
            super(new String[]{"wc-status", "repos-status"}, new String[0]);
            this.myBase = base;
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
            String path = attributes.getValue("path");
            SvnStatusHandler.assertSAX(path != null);
            File file = CommandUtil.resolvePath(this.myBase, path);
            status.setFile(file);
            boolean exists = file.exists();
            if (exists) {
                status.setKind(exists, file.isDirectory() ? SVNNodeKind.DIR : SVNNodeKind.FILE);
            } else {
                SVNStatusType ns = status.getNodeStatus();
                if (this.myBase.getName().equals(path) && !SVNStatusType.MISSING.equals(ns) && !SVNStatusType.STATUS_DELETED.equals(ns)) {
                    status.setKind(true, SVNNodeKind.DIR);
                    status.setFile(this.myBase);
                    status.setPath("");
                    return;
                }
                status.setKind(exists, SVNNodeKind.UNKNOWN);
            }
            status.setPath(path);
        }

        @Override
        public void postEffect(DataCallback callback) {
            callback.switchPath();
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
        }
    }

    private static class WcStatus
    extends ElementHandlerBase {
        private WcStatus() {
            super(new String[]{"commit", "lock"}, new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
            String revision;
            String switched;
            String treeConflicted;
            String copied;
            String locked;
            SVNStatusType propertiesStatus = SvnStatusHandler.parsePropertiesStatus(attributes);
            status.setPropertiesStatus(propertiesStatus);
            SVNStatusType contentsStatus = SvnStatusHandler.parseContentsStatus(attributes);
            status.setContentsStatus(contentsStatus);
            if (SVNStatusType.STATUS_CONFLICTED.equals(propertiesStatus) || SVNStatusType.STATUS_CONFLICTED.equals(contentsStatus)) {
                status.setIsConflicted(true);
            }
            if ((locked = attributes.getValue("wc-locked")) != null && Boolean.parseBoolean(locked)) {
                status.setIsLocked(true);
            }
            if ((copied = attributes.getValue("copied")) != null && Boolean.parseBoolean(copied)) {
                status.setIsCopied(true);
            }
            if ((treeConflicted = attributes.getValue("tree-conflicted")) != null && Boolean.parseBoolean(treeConflicted)) {
                status.setIsConflicted(true);
            }
            if ((switched = attributes.getValue("switched")) != null && Boolean.parseBoolean(switched)) {
                status.setIsSwitched(true);
            }
            if (!StringUtil.isEmptyOrSpaces((String)(revision = attributes.getValue("revision")))) {
                try {
                    long number = Long.parseLong(revision);
                    status.setRevision(SVNRevision.create((long)number));
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
            }
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
        }
    }

    private static class ReposStatus
    extends ElementHandlerBase {
        private ReposStatus() {
            super(new String[]{"lock"}, new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
            SVNStatusType propertiesStatus = SvnStatusHandler.parsePropertiesStatus(attributes);
            status.setRemotePropertiesStatus(propertiesStatus);
            SVNStatusType contentsStatus = SvnStatusHandler.parseContentsStatus(attributes);
            status.setRemoteContentsStatus(contentsStatus);
        }

        @Override
        public void postEffect(DataCallback callback) {
            callback.endRemoteStatus();
        }

        @Override
        public void preAttributesEffect(DataCallback callback) {
            callback.startLock();
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
        }
    }

    private static class Lock
    extends ElementHandlerBase {
        private Lock() {
            super(new String[]{"token", "owner", "comment", "created"}, new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
            lock.setPath(status.getPath());
        }

        @Override
        public void postEffect(DataCallback callback) {
            callback.endLock();
        }

        @Override
        public void preAttributesEffect(DataCallback callback) {
            callback.startLock();
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
        }
    }

    private static class LockToken
    extends ElementHandlerBase {
        private LockToken() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
            lock.setID(s);
        }
    }

    private static class LockOwner
    extends ElementHandlerBase {
        private LockOwner() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
            lock.setOwner(s);
        }
    }

    private static class LockComment
    extends ElementHandlerBase {
        private LockComment() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
            lock.setComment(s);
        }
    }

    private static class LockCreatedDate
    extends ElementHandlerBase {
        private LockCreatedDate() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
            SVNDate date = SVNDate.parseDate((String)s);
            lock.setCreationDate((java.util.Date)date);
        }
    }

    private static class Commit
    extends ElementHandlerBase {
        private Commit() {
            super(new String[]{"author", "date"}, new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
            String revision = attributes.getValue("revision");
            if (!StringUtil.isEmpty((String)revision)) {
                status.setCommittedRevision(SVNRevision.create((long)Long.valueOf(revision)));
            }
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
        }
    }

    private static class Author
    extends ElementHandlerBase {
        private Author() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
            pending.setAuthor(s);
        }
    }

    private static class Date
    extends ElementHandlerBase {
        private Date() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
            pending.setCommittedDate((java.util.Date)SVNDate.parseDate((String)s));
        }
    }

    private static class Fake
    extends ElementHandlerBase {
        private Fake() {
            super(new String[]{"status"}, new String[0]);
        }

        @Override
        protected void updateStatus(Attributes attributes, PortableStatus status, SVNLockWrapper lock) throws SAXException {
        }

        @Override
        public void postEffect(DataCallback callback) {
        }

        @Override
        public void preEffect(DataCallback callback) {
        }

        @Override
        public void characters(String s, PortableStatus pending, SVNLockWrapper lock) {
        }
    }
}

