/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.ExecutableValidator;
import com.intellij.notification.Notification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;

public class SvnExecutableChecker
extends ExecutableValidator {
    private static final Logger LOG = Logger.getInstance(SvnExecutableChecker.class);

    public SvnExecutableChecker(Project project) {
        super(project, SvnExecutableChecker.getNotificationTitle(), SvnExecutableChecker.getWrongPathMessage());
    }

    protected String getCurrentExecutable() {
        return SvnApplicationSettings.getInstance().getCommandLinePath();
    }

    @NotNull
    protected Configurable getConfigurable() {
        Configurable configurable = this.getVcs().getConfigurable();
        if (configurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "getConfigurable"));
        }
        return configurable;
    }

    @NotNull
    private SvnVcs getVcs() {
        SvnVcs svnVcs = SvnVcs.getInstance(this.myProject);
        if (svnVcs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "getVcs"));
        }
        return svnVcs;
    }

    protected void showSettingsAndExpireIfFixed(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "showSettingsAndExpireIfFixed"));
        }
        this.showSettings();
        notification.expire();
        this.getVcs().checkCommandLineVersion();
    }

    protected boolean isExecutableValid(@NotNull String executable) {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "isExecutableValid"));
        }
        this.setNotificationErrorDescription(SvnExecutableChecker.getWrongPathMessage());
        Version version = this.getConfiguredClientVersion();
        try {
            return version != null && this.validateVersion(version);
        }
        catch (Throwable e) {
            LOG.info(e);
            return false;
        }
    }

    private boolean validateVersion(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "validateVersion"));
        }
        if (version.lessThan(Integer.valueOf(1), Integer.valueOf(7))) {
            this.setNotificationErrorDescription(SvnExecutableChecker.getOldExecutableMessage(version));
            return false;
        }
        return true;
    }

    @Nullable
    private Version getConfiguredClientVersion() {
        Version result = null;
        try {
            result = this.getVcs().getCommandLineFactory().createVersionClient().getVersion();
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        return result;
    }

    private static String getWrongPathMessage() {
        return SvnBundle.message("subversion.executable.notification.description", new Object[0]);
    }

    private static String getNotificationTitle() {
        return SvnBundle.message("subversion.executable.notification.title", new Object[0]);
    }

    private static String getOldExecutableMessage(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "getOldExecutableMessage"));
        }
        return SvnBundle.message("subversion.executable.too.old", version);
    }
}

