/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.CommitEventHandler;
import org.jetbrains.idea.svn.commandLine.CommitEventType;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnCommitRunner {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.svn.commandLine.SvnCommitRunner");
    public static final long INVALID_REVISION_NUMBER = -1L;
    private CommandListener myCommandListener;
    private SvnVcs myVcs;

    public SvnCommitRunner(@NotNull SvnVcs vcs, @Nullable CommitEventHandler handler) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnCommitRunner", "<init>"));
        }
        this.myVcs = vcs;
        this.myCommandListener = new CommandListener(handler);
    }

    public long commit(File[] paths, String message, @Nullable SVNDepth depth, boolean noUnlock, boolean keepChangelist, Collection<String> changelists, Map revpropTable) throws VcsException {
        if (paths.length == 0) {
            return -1L;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, depth);
        CommandUtil.put(parameters, noUnlock, "--no-unlock");
        CommandUtil.put(parameters, keepChangelist, "--keep-changelists");
        CommandUtil.putChangeLists(parameters, changelists);
        if (revpropTable != null && !revpropTable.isEmpty()) {
            Set set = revpropTable.entrySet();
            for (Map.Entry entry : set) {
                parameters.add("--with-revprop");
                parameters.add(entry.getKey() + "=" + entry.getValue());
            }
        }
        parameters.add("-m");
        parameters.add(message);
        Arrays.sort(paths);
        CommandUtil.put(parameters, paths);
        this.myCommandListener.setBaseDirectory(CommandUtil.correctUpToExistingParent(paths[0]));
        CommandUtil.execute(this.myVcs, SvnTarget.fromFile((File)paths[0]), SvnCommandName.ci, parameters, this.myCommandListener);
        this.myCommandListener.throwExceptionIfOccurred();
        return this.validateRevisionNumber();
    }

    private long validateRevisionNumber() throws VcsException {
        long revision = this.myCommandListener.getCommittedRevision();
        if (revision < 0L) {
            throw new VcsException("Wrong committed revision number: " + revision);
        }
        return revision;
    }

    public static class CommandListener
    extends LineCommandAdapter {
        private static final String STATUS = "\\s*(\\w+)(.*?)\\s\\s+";
        private static final String OPTIONAL_FILE_TYPE = "(\\(.*\\))?";
        private static final String PATH = "\\s*(.*?)\\s*";
        private static final Pattern CHANGED_PATH = Pattern.compile("\\s*(\\w+)(.*?)\\s\\s+(\\(.*\\))?\\s*(.*?)\\s*");
        @Nullable
        private final CommitEventHandler myHandler;
        private SvnBindException myException;
        private long myCommittedRevision = -1L;
        private File myBase;

        public CommandListener(@Nullable CommitEventHandler handler) {
            this.myHandler = handler;
        }

        public void throwExceptionIfOccurred() throws VcsException {
            if (this.myException != null) {
                throw this.myException;
            }
        }

        public long getCommittedRevision() {
            return this.myCommittedRevision;
        }

        public void setBaseDirectory(@NotNull File file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnCommitRunner$CommandListener", "setBaseDirectory"));
            }
            this.myBase = file;
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            String trim = line.trim();
            if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                try {
                    this.parseLine(trim);
                }
                catch (SvnBindException e) {
                    this.myException = e;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void parseLine(String line) throws SvnBindException {
            if (StringUtil.isEmptyOrSpaces((String)line)) {
                return;
            }
            if (line.startsWith(CommitEventType.transmittingDeltas.getText())) {
                if (this.myHandler == null) return;
                this.myHandler.commitEvent(CommitEventType.transmittingDeltas, this.myBase);
                return;
            }
            if (line.startsWith(CommitEventType.skipped.getText())) {
                int pathEnd;
                File target = null;
                if (this.myHandler == null) return;
                int pathStart = line.indexOf(39);
                if (pathStart > -1 && (pathEnd = line.indexOf(39, pathStart + 1)) > -1) {
                    target = this.toFile(line.substring(pathStart + 1, pathEnd));
                }
                if (target != null) {
                    this.myHandler.commitEvent(CommitEventType.skipped, this.myBase);
                    return;
                }
                LOG.info("Can not parse 'Skipped' path " + line);
                return;
            }
            if (line.startsWith(CommitEventType.committedRevision.getText())) {
                String substring = line.substring(CommitEventType.committedRevision.getText().length());
                int cnt = 0;
                while (StringUtil.isWhiteSpace((char)substring.charAt(cnt))) {
                    ++cnt;
                }
                StringBuilder num = new StringBuilder();
                while (Character.isDigit(substring.charAt(cnt))) {
                    num.append(substring.charAt(cnt));
                    ++cnt;
                }
                if (num.length() <= 0) {
                    String message = "Missing committed revision number: " + num.toString() + ", string: " + line;
                    LOG.info(message);
                    throw new SvnBindException(message);
                }
                try {
                    this.myCommittedRevision = Long.parseLong(num.toString());
                    if (this.myHandler == null) return;
                    this.myHandler.committedRevision(this.myCommittedRevision);
                    return;
                }
                catch (NumberFormatException e) {
                    String message = "Wrong committed revision number: " + num.toString() + ", string: " + line;
                    LOG.info(message, (Throwable)e);
                    throw new SvnBindException(message);
                }
            }
            if (this.myHandler == null) {
                return;
            }
            Matcher matcher = CHANGED_PATH.matcher(line);
            if (!matcher.matches()) {
                LOG.info("Can not parse output: " + line);
                return;
            }
            CommitEventType type = CommitEventType.create(matcher.group(1));
            if (type == null) {
                LOG.info("Can not parse event type: " + line);
                return;
            }
            this.myHandler.commitEvent(type, this.toFile(matcher.group(4)));
        }

        @NotNull
        private File toFile(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnCommitRunner$CommandListener", "toFile"));
            }
            File file = CommandUtil.resolvePath(this.myBase, path);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SvnCommitRunner$CommandListener", "toFile"));
            }
            return file;
        }
    }
}

