/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.Convertor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandLineInfoClient;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnStatusHandler;
import org.jetbrains.idea.svn.portable.PortableStatus;
import org.jetbrains.idea.svn.portable.SvnExceptionWrapper;
import org.jetbrains.idea.svn.portable.SvnStatusClientI;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SvnCommandLineStatusClient
implements SvnStatusClientI {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.commandLine.SvnCommandLineStatusClient");
    private final SvnCommandLineInfoClient myInfoClient;
    @NotNull
    private final SvnVcs myVcs;

    public SvnCommandLineStatusClient(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnCommandLineStatusClient", "<init>"));
        }
        this.myVcs = vcs;
        this.myInfoClient = new SvnCommandLineInfoClient(vcs);
    }

    @Override
    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, recursive, remote, reportAll, includeIgnored, false, handler);
    }

    @Override
    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, SVNRevision.UNDEFINED, recursive, remote, reportAll, includeIgnored, collectParentExternals, handler);
    }

    @Override
    public long doStatus(File path, SVNRevision revision, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, revision, recursive ? SVNDepth.INFINITY : SVNDepth.EMPTY, remote, reportAll, includeIgnored, collectParentExternals, handler, null);
    }

    @Override
    public long doStatus(File path, SVNRevision revision, SVNDepth depth, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, ISVNStatusHandler handler, Collection changeLists) throws SVNException {
        CommandExecutor command;
        File base = path.isDirectory() ? path : path.getParentFile();
        base = CommandUtil.correctUpToExistingParent(base);
        SVNInfo infoBase = this.myInfoClient.doInfo(base, revision);
        ArrayList<String> parameters = new ArrayList<String>();
        SvnCommandLineStatusClient.putParameters(parameters, path, depth, remote, reportAll, includeIgnored, changeLists);
        try {
            command = CommandUtil.execute(this.myVcs, SvnTarget.fromFile((File)path), SvnCommandName.st, parameters, null);
        }
        catch (VcsException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e), (Throwable)e);
        }
        this.parseResult(path, revision, handler, base, infoBase, command);
        return 0L;
    }

    private void parseResult(final File path, SVNRevision revision, ISVNStatusHandler handler, File base, SVNInfo infoBase, CommandExecutor command) throws SVNException {
        String result = command.getOutput();
        if (StringUtil.isEmptyOrSpaces((String)result)) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)("Status request returned nothing for command: " + command.myCommandLine.getCommandLineString())));
        }
        try {
            SvnStatusHandler[] svnHandl;
            svnHandl = new SvnStatusHandler[]{this.createStatusHandler(revision, handler, base, infoBase, svnHandl)};
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(result.getBytes(CharsetToolkit.UTF8_CHARSET)), (DefaultHandler)svnHandl[0]);
            if (!svnHandl[0].isAnythingReported()) {
                if (!SvnUtil.isSvnVersioned(this.myVcs, path)) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_NOT_DIRECTORY, (String)("Command - " + command.getCommandText() + ". Result - " + result)));
                }
                PortableStatus status = new PortableStatus();
                status.setPath(path.getAbsolutePath());
                status.setContentsStatus(SVNStatusType.STATUS_NORMAL);
                status.setInfoGetter(new Getter<SVNInfo>(){

                    public SVNInfo get() {
                        return (SVNInfo)SvnCommandLineStatusClient.this.createInfoGetter(null).convert((Object)path);
                    }
                });
                handler.handleStatus((SVNStatus)status);
            }
        }
        catch (SvnExceptionWrapper e) {
            throw (SVNException)e.getCause();
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e), (Throwable)e);
        }
        catch (SAXException e) {
            command.logCommand();
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e), (Throwable)e);
        }
    }

    private static void putParameters(@NotNull List<String> parameters, @NotNull File path, @Nullable SVNDepth depth, boolean remote, boolean reportAll, boolean includeIgnored, @Nullable Collection changeLists) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnCommandLineStatusClient", "putParameters"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/SvnCommandLineStatusClient", "putParameters"));
        }
        CommandUtil.put(parameters, path);
        CommandUtil.put(parameters, depth);
        CommandUtil.put(parameters, remote, "-u");
        CommandUtil.put(parameters, reportAll, "--verbose");
        CommandUtil.put(parameters, includeIgnored, "--no-ignore");
        CommandUtil.putChangeLists(parameters, changeLists);
        parameters.add("--xml");
    }

    public SvnStatusHandler createStatusHandler(SVNRevision revision, ISVNStatusHandler handler, File base, SVNInfo infoBase, SvnStatusHandler[] svnHandl) {
        SvnStatusHandler.ExternalDataCallback callback = SvnCommandLineStatusClient.createStatusCallback(handler, base, infoBase, svnHandl);
        return new SvnStatusHandler(callback, base, this.createInfoGetter(revision));
    }

    private Convertor<File, SVNInfo> createInfoGetter(final SVNRevision revision) {
        return new Convertor<File, SVNInfo>(){

            public SVNInfo convert(File o) {
                try {
                    return SvnCommandLineStatusClient.this.myInfoClient.doInfo(o, revision);
                }
                catch (SVNException e) {
                    throw new SvnExceptionWrapper(e);
                }
            }
        };
    }

    public static SvnStatusHandler.ExternalDataCallback createStatusCallback(final ISVNStatusHandler handler, final File base, final SVNInfo infoBase, final SvnStatusHandler[] svnHandl) {
        final HashMap externalsMap = new HashMap();
        final String[] changelistName = new String[1];
        return new SvnStatusHandler.ExternalDataCallback(){

            @Override
            public void switchPath() {
                PortableStatus pending = svnHandl[0].getPending();
                pending.setChangelistName(changelistName[0]);
                try {
                    SVNInfo baseInfo = infoBase;
                    File baseFile = base;
                    File pendingFile = new File(pending.getPath());
                    if (!externalsMap.isEmpty()) {
                        for (File file : externalsMap.keySet()) {
                            if (!FileUtil.isAncestor((File)file, (File)pendingFile, (boolean)false)) continue;
                            baseInfo = (SVNInfo)externalsMap.get(file);
                            baseFile = file;
                            break;
                        }
                    }
                    if (baseInfo != null) {
                        String append;
                        String systemIndependentPath = FileUtil.toSystemIndependentName((String)pending.getPath());
                        if (pendingFile.isAbsolute()) {
                            String relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)baseFile.getPath()), (String)systemIndependentPath, (char)'/');
                            append = SVNPathUtil.append((String)baseInfo.getURL().toString(), (String)FileUtil.toSystemIndependentName((String)relativePath));
                        } else {
                            append = SVNPathUtil.append((String)baseInfo.getURL().toString(), (String)systemIndependentPath);
                        }
                        pending.setURL(SVNURL.parseURIEncoded((String)append));
                    }
                    if (SVNStatusType.STATUS_EXTERNAL.equals(pending.getNodeStatus())) {
                        externalsMap.put(pending.getFile(), pending.getInfo());
                    }
                    handler.handleStatus((SVNStatus)pending);
                }
                catch (SVNException e) {
                    throw new SvnExceptionWrapper(e);
                }
            }

            @Override
            public void switchChangeList(String newList) {
                changelistName[0] = newList;
            }
        };
    }

    @Override
    public SVNStatus doStatus(File path, boolean remote) throws SVNException {
        return this.doStatus(path, remote, false);
    }

    @Override
    public SVNStatus doStatus(File path, boolean remote, boolean collectParentExternals) throws SVNException {
        final SVNStatus[] svnStatus = new SVNStatus[1];
        this.doStatus(path, SVNRevision.UNDEFINED, SVNDepth.EMPTY, remote, false, false, collectParentExternals, new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) throws SVNException {
                svnStatus[0] = status;
            }
        }, null);
        return svnStatus[0];
    }
}

