/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnInfoHandler;
import org.jetbrains.idea.svn.portable.SvnExceptionWrapper;
import org.jetbrains.idea.svn.portable.SvnkitSvnWcClient;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SvnCommandLineInfoClient
extends SvnkitSvnWcClient {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.commandLine.SvnCommandLineInfoClient");
    @NotNull
    private final SvnVcs myVcs;

    public SvnCommandLineInfoClient(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnCommandLineInfoClient", "<init>"));
        }
        super(vcs);
        this.myVcs = vcs;
    }

    @Override
    public void doInfo(File path, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.doInfo(path, SVNRevision.UNDEFINED, revision, recursive ? SVNDepth.INFINITY : SVNDepth.EMPTY, null, handler);
    }

    @Override
    public void doInfo(File path, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.doInfo(path, pegRevision, revision, recursive ? SVNDepth.INFINITY : SVNDepth.EMPTY, null, handler);
    }

    @Override
    public void doInfo(File path, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, Collection changeLists, ISVNInfoHandler handler) throws SVNException {
        File base = path.isDirectory() ? path : path.getParentFile();
        if ((base = CommandUtil.correctUpToExistingParent(base)) == null) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)"Can not find existing parent file"));
        }
        this.issueCommand(path, pegRevision, revision, depth, changeLists, handler, base);
    }

    private void issueCommand(File path, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, Collection changeLists, ISVNInfoHandler handler, File base) throws SVNException {
        ArrayList<String> parameters = new ArrayList<String>();
        SvnCommandLineInfoClient.fillParameters(path.getAbsolutePath(), pegRevision, revision, depth, parameters);
        CommandUtil.putChangeLists(parameters, changeLists);
        SvnCommandLineInfoClient.parseResult(handler, base, this.execute(parameters, path));
    }

    private String execute(@NotNull List<String> parameters, @NotNull File path) throws SVNException {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnCommandLineInfoClient", "execute"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/SvnCommandLineInfoClient", "execute"));
        }
        final ProcessOutput output = new ProcessOutput();
        LineCommandAdapter listener = new LineCommandAdapter(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType == ProcessOutputTypes.STDOUT) {
                    output.appendStdout(line);
                }
            }
        };
        try {
            CommandExecutor command = CommandUtil.execute(this.myVcs, SvnTarget.fromFile((File)path), SvnCommandName.info, parameters, listener);
            return command.getOutput();
        }
        catch (VcsException e) {
            boolean notEmpty;
            String text = e.getMessage();
            boolean bl = notEmpty = !StringUtil.isEmptyOrSpaces((String)text);
            if (notEmpty && text.contains("W155010")) {
                return output.getStdout();
            }
            if (notEmpty && text.contains("is not a working copy")) {
                if (StringUtil.isNotEmpty((String)output.getStdout())) {
                    return output.getStdout() + "</info>";
                }
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_NOT_WORKING_COPY, (Throwable)e), (Throwable)e);
            }
            if (notEmpty && text.contains("some targets don't exist")) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ILLEGAL_TARGET, (Throwable)e), (Throwable)e);
            }
            if (notEmpty && text.contains(String.valueOf(SVNErrorCode.WC_UPGRADE_REQUIRED.getCode()))) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_UPGRADE_REQUIRED, (Throwable)e), (Throwable)e);
            }
            if (notEmpty && (text.contains("upgrade your Subversion client") || text.contains(String.valueOf(SVNErrorCode.WC_UNSUPPORTED_FORMAT.getCode())))) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_UNSUPPORTED_FORMAT, (Throwable)e), (Throwable)e);
            }
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e), (Throwable)e);
        }
    }

    private static void parseResult(final @NotNull ISVNInfoHandler handler, @Nullable File base, @Nullable String result) throws SVNException {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnCommandLineInfoClient", "parseResult"));
        }
        if (StringUtil.isEmpty((String)result)) {
            return;
        }
        SvnInfoHandler[] infoHandler = new SvnInfoHandler[]{new SvnInfoHandler(base, new Consumer<SVNInfo>(){

            public void consume(SVNInfo info) {
                try {
                    handler.handleInfo(info);
                }
                catch (SVNException e) {
                    throw new SvnExceptionWrapper(e);
                }
            }
        })};
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(result.getBytes(CharsetToolkit.UTF8_CHARSET)), (DefaultHandler)infoHandler[0]);
        }
        catch (SvnExceptionWrapper e) {
            LOG.info("info output " + result);
            throw (SVNException)e.getCause();
        }
        catch (IOException e) {
            LOG.info("info output " + result);
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOG.info("info output " + result);
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e), (Throwable)e);
        }
        catch (SAXException e) {
            LOG.info("info output " + result);
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e), (Throwable)e);
        }
    }

    private static void fillParameters(String path, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, List<String> parameters) {
        CommandUtil.put(parameters, depth);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, path, pegRevision);
        parameters.add("--xml");
    }

    @Override
    public void doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.doInfo(url, pegRevision, revision, recursive ? SVNDepth.INFINITY : SVNDepth.EMPTY, handler);
    }

    @Override
    public void doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, ISVNInfoHandler handler) throws SVNException {
        CommandExecutor command;
        String path = url.toDecodedString();
        ArrayList<String> parameters = new ArrayList<String>();
        SvnCommandLineInfoClient.fillParameters(path, pegRevision, revision, depth, parameters);
        try {
            command = CommandUtil.execute(this.myVcs, SvnTarget.fromURL((SVNURL)url), SvnCommandName.info, parameters, null);
        }
        catch (VcsException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e), (Throwable)e);
        }
        SvnCommandLineInfoClient.parseResult(handler, null, command.getOutput());
    }

    @Override
    public SVNInfo doInfo(File path, SVNRevision revision) throws SVNException {
        final SVNInfo[] infoArr = new SVNInfo[1];
        this.doInfo(path, SVNRevision.UNDEFINED, revision, SVNDepth.EMPTY, null, new ISVNInfoHandler(){

            public void handleInfo(SVNInfo info) throws SVNException {
                infoArr[0] = info;
            }
        });
        return infoArr[0];
    }

    @Override
    public SVNInfo doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        final SVNInfo[] infoArr = new SVNInfo[1];
        this.doInfo(url, pegRevision, revision, SVNDepth.EMPTY, new ISVNInfoHandler(){

            public void handleInfo(SVNInfo info) throws SVNException {
                infoArr[0] = info;
            }
        });
        return infoArr[0];
    }

    @Override
    public void doInfo(@NotNull Collection<File> paths, @Nullable ISVNInfoHandler handler) throws SVNException {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnCommandLineInfoClient", "doInfo"));
        }
        File base = (File)ContainerUtil.getFirstItem(paths);
        if (base != null) {
            base = CommandUtil.correctUpToExistingParent(base);
            ArrayList parameters = ContainerUtil.newArrayList();
            for (File file : paths) {
                CommandUtil.put((List<String>)parameters, file);
            }
            parameters.add("--xml");
            String result = this.execute(parameters, base);
            if (handler != null) {
                SvnCommandLineInfoClient.parseResult(handler, base, result);
            }
        }
    }
}

