/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;

public class SvnBindException
extends VcsException {
    public static final int ERROR_BASE = 120000;
    public static final int CATEGORY_SIZE = 5000;
    private Map<Integer, String> errors = new HashMap();

    public SvnBindException(String message) {
        super(message);
        if (!StringUtil.isEmpty((String)message)) {
            this.parseErrors(message);
        }
    }

    public SvnBindException(Throwable throwable) {
        super(throwable);
        if (throwable instanceof SVNException) {
            SVNException e = (SVNException)throwable;
            int code = e.getErrorMessage().getErrorCode().getCode();
            this.put(code, e.getMessage());
        }
    }

    public boolean contains(int error) {
        return this.errors.containsKey(error);
    }

    public boolean contains(@NotNull SVNErrorCode error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnBindException", "contains"));
        }
        return this.errors.containsKey(error.getCode());
    }

    public boolean containsCategory(int category) {
        final int categoryCode = SvnBindException.getCategoryCode(category);
        return ContainerUtil.exists(this.errors.keySet(), (Condition)new Condition<Integer>(){

            public boolean value(Integer code) {
                return SvnBindException.getCategoryCode(code) == categoryCode;
            }
        });
    }

    private static int getCategoryCode(int category) {
        return (category - 120000) / 5000;
    }

    private void parseErrors(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnBindException", "parseErrors"));
        }
        Matcher matcher = SvnUtil.ERROR_PATTERN.matcher(message);
        while (matcher.find()) {
            this.put(Integer.valueOf(matcher.group(2)), matcher.group());
        }
    }

    private void put(int code, @Nullable String message) {
        if (this.errors.containsKey(code)) {
            if (!StringUtil.isEmpty((String)message)) {
                this.errors.put(code, this.errors.get(code) + LineSeparator.LF.getSeparatorString() + message);
            }
        } else {
            this.errors.put(code, message);
        }
    }
}

