/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.checkin.IdeaSvnkitBasedAuthenticationCallback;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CommandUtil {
    @NotNull
    public static File resolvePath(@NotNull File base, @NotNull String path) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "resolvePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandUtil", "resolvePath"));
        }
        File result = new File(path);
        if (!result.isAbsolute()) {
            result = ".".equals(path) ? base : new File(base, path);
        }
        File file = result;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandUtil", "resolvePath"));
        }
        return file;
    }

    public static void put(@NotNull List<String> parameters, boolean condition, @NotNull String value) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (condition) {
            parameters.add(value);
        }
    }

    public static void put(@NotNull List<String> parameters, @NotNull File path) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        CommandUtil.put(parameters, path.getAbsolutePath(), SVNRevision.UNDEFINED);
    }

    public static void put(@NotNull List<String> parameters, @NotNull File path, boolean usePegRevision) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (usePegRevision) {
            CommandUtil.put(parameters, path);
        } else {
            parameters.add(path.getAbsolutePath());
        }
    }

    public static void put(@NotNull List<String> parameters, @NotNull File path, @Nullable SVNRevision pegRevision) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        CommandUtil.put(parameters, path.getAbsolutePath(), pegRevision);
    }

    public static void put(@NotNull List<String> parameters, @NotNull String path, @Nullable SVNRevision pegRevision) {
        boolean hasPegRevision;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        StringBuilder builder = new StringBuilder(path);
        boolean hasAtSymbol = path.contains("@");
        boolean bl = hasPegRevision = pegRevision != null && !SVNRevision.UNDEFINED.equals((Object)pegRevision) && !SVNRevision.WORKING.equals((Object)pegRevision) && pegRevision.isValid() && pegRevision.getNumber() != 0L;
        if (hasPegRevision || hasAtSymbol) {
            builder.append("@");
        }
        if (hasPegRevision) {
            builder.append(pegRevision);
        }
        parameters.add(builder.toString());
    }

    public static void put(@NotNull List<String> parameters, @NotNull SvnTarget target) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        CommandUtil.put(parameters, target.getPathOrUrlString(), target.getPegRevision());
    }

    public static void put(@NotNull List<String> parameters, @NotNull SvnTarget target, boolean usePegRevision) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (usePegRevision) {
            CommandUtil.put(parameters, target);
        } else {
            parameters.add(target.getPathOrUrlString());
        }
    }

    public static void put(@NotNull List<String> parameters, File ... paths) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        for (File path : paths) {
            CommandUtil.put(parameters, path);
        }
    }

    public static void put(@NotNull List<String> parameters, @Nullable SVNDepth depth) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        CommandUtil.put(parameters, depth, false);
    }

    public static void put(@NotNull List<String> parameters, @Nullable SVNDepth depth, boolean sticky) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (depth != null && !SVNDepth.UNKNOWN.equals((Object)depth)) {
            parameters.add("--depth");
            parameters.add(depth.getName());
            if (sticky) {
                parameters.add("--set-depth");
                parameters.add(depth.getName());
            }
        }
    }

    public static void put(@NotNull List<String> parameters, @Nullable SVNRevision revision) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (revision != null && !SVNRevision.UNDEFINED.equals((Object)revision) && !SVNRevision.WORKING.equals((Object)revision) && revision.isValid()) {
            parameters.add("--revision");
            parameters.add(revision.toString());
        }
    }

    public static void put(@NotNull List<String> parameters, @Nullable SVNDiffOptions diffOptions) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "put"));
        }
        if (diffOptions != null) {
            String value;
            StringBuilder builder = new StringBuilder();
            if (diffOptions.isIgnoreAllWhitespace()) {
                builder.append(" --ignore-space-change");
            }
            if (diffOptions.isIgnoreAmountOfWhitespace()) {
                builder.append(" --ignore-all-space");
            }
            if (diffOptions.isIgnoreEOLStyle()) {
                builder.append(" --ignore-eol-style");
            }
            if (!StringUtil.isEmpty((String)(value = builder.toString().trim()))) {
                parameters.add("--extensions");
                parameters.add(value);
            }
        }
    }

    public static void putChangeLists(@NotNull List<String> parameters, @Nullable Iterable<String> changeLists) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "putChangeLists"));
        }
        if (changeLists != null) {
            for (String changeList : changeLists) {
                parameters.add("--cl");
                parameters.add(changeList);
            }
        }
    }

    public static String escape(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "escape"));
        }
        return path.contains("@") ? path + "@" : path;
    }

    public static <T> T parse(@NotNull String data, @NotNull Class<T> type) throws JAXBException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "parse"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandUtil", "parse"));
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (T)unmarshaller.unmarshal((Reader)new StringReader(data));
    }

    public static CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @NotNull SvnCommandName name, @NotNull List<String> parameters, @Nullable LineCommandListener listener) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "execute"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandUtil", "execute"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/commandLine/CommandUtil", "execute"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/idea/svn/commandLine/CommandUtil", "execute"));
        }
        return CommandUtil.execute(vcs, target, null, name, parameters, listener);
    }

    public static CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @Nullable File workingDirectory, @NotNull SvnCommandName name, @NotNull List<String> parameters, @Nullable LineCommandListener listener) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandUtil", "execute"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandUtil", "execute"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/idea/svn/commandLine/CommandUtil", "execute"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/idea/svn/commandLine/CommandUtil", "execute"));
        }
        Command command = new Command(name);
        command.setTarget(target);
        command.setWorkingDirectory(workingDirectory);
        command.setResultBuilder(listener);
        command.put(parameters);
        CommandRuntime runtime = new CommandRuntime(vcs, new IdeaSvnkitBasedAuthenticationCallback(vcs));
        return runtime.runWithAuthenticationAttempt(command);
    }

    @NotNull
    public static File getHomeDirectory() {
        File file = new File(PathManager.getHomePath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandUtil", "getHomeDirectory"));
        }
        return file;
    }

    public static char getStatusChar(@Nullable String type) {
        return !StringUtil.isEmpty((String)type) ? type.charAt(0) : (char)' ';
    }

    @NotNull
    public static SVNStatusType getStatusType(@Nullable String type) {
        SVNStatusType sVNStatusType = CommandUtil.getStatusType(CommandUtil.getStatusChar(type));
        if (sVNStatusType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandUtil", "getStatusType"));
        }
        return sVNStatusType;
    }

    @NotNull
    public static SVNStatusType getStatusType(char first) {
        SVNStatusType contentsStatus = 'A' == first ? SVNStatusType.STATUS_ADDED : ('D' == first ? SVNStatusType.STATUS_DELETED : ('U' == first ? SVNStatusType.CHANGED : ('C' == first ? SVNStatusType.CONFLICTED : ('G' == first ? SVNStatusType.MERGED : ('R' == first ? SVNStatusType.STATUS_REPLACED : ('E' == first ? SVNStatusType.STATUS_OBSTRUCTED : SVNStatusType.STATUS_NORMAL))))));
        SVNStatusType sVNStatusType = contentsStatus;
        if (sVNStatusType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandUtil", "getStatusType"));
        }
        return sVNStatusType;
    }

    public static File correctUpToExistingParent(File base) {
        while (base != null) {
            if (base.exists() && base.isDirectory()) {
                return base;
            }
            base = base.getParentFile();
        }
        return null;
    }
}

