/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.InfoCommandRepositoryProvider;
import org.jetbrains.idea.svn.api.Repository;
import org.jetbrains.idea.svn.api.UrlMappingRepositoryProvider;
import org.jetbrains.idea.svn.commandLine.BaseCommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CommandParametersResolutionModule
extends BaseCommandRuntimeModule {
    public CommandParametersResolutionModule(@NotNull CommandRuntime runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandParametersResolutionModule", "<init>"));
        }
        super(runtime);
    }

    @Override
    public void onStart(@NotNull Command command) throws SvnBindException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandParametersResolutionModule", "onStart"));
        }
        if (command.getRepositoryUrl() == null) {
            command.setRepositoryUrl(this.resolveRepositoryUrl(command));
        }
        if (command.getWorkingDirectory() == null) {
            command.setWorkingDirectory(this.resolveWorkingDirectory(command));
        }
        command.setConfigDir(this.myAuthCallback.getSpecialConfigDir());
        command.saveOriginalParameters();
    }

    @Nullable
    private SVNURL resolveRepositoryUrl(@NotNull Command command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandParametersResolutionModule", "resolveRepositoryUrl"));
        }
        UrlMappingRepositoryProvider urlMappingProvider = new UrlMappingRepositoryProvider(this.myVcs, command.getTarget());
        InfoCommandRepositoryProvider infoCommandProvider = new InfoCommandRepositoryProvider(this.myVcs, command.getTarget());
        Repository repository = urlMappingProvider.get();
        if (repository == null && !SvnCommandName.info.equals((Object)command.getName())) {
            repository = infoCommandProvider.get();
        }
        return repository != null ? repository.getUrl() : null;
    }

    @NotNull
    private File resolveWorkingDirectory(@NotNull Command command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandParametersResolutionModule", "resolveWorkingDirectory"));
        }
        SvnTarget target = command.getTarget();
        File workingDirectory = target.isFile() ? target.getFile() : null;
        if ((workingDirectory = CommandUtil.correctUpToExistingParent(workingDirectory)) == null) {
            workingDirectory = !this.myVcs.getProject().isDefault() ? VfsUtilCore.virtualToIoFile((VirtualFile)this.myVcs.getProject().getBaseDir()) : CommandUtil.getHomeDirectory();
        }
        File file = workingDirectory;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandParametersResolutionModule", "resolveWorkingDirectory"));
        }
        return file;
    }
}

