/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.UpdateOutputLineConverter;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;

public class BaseUpdateCommandListener
extends LineCommandAdapter {
    @NotNull
    private final UpdateOutputLineConverter converter;
    @Nullable
    private final ISVNEventHandler handler;
    @NotNull
    private final AtomicReference<SVNException> exception;

    public BaseUpdateCommandListener(@NotNull File base, @Nullable ISVNEventHandler handler) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/BaseUpdateCommandListener", "<init>"));
        }
        this.handler = handler;
        this.converter = new UpdateOutputLineConverter(base);
        this.exception = new AtomicReference();
    }

    @Override
    public void onLineAvailable(String line, Key outputType) {
        SVNEvent event;
        if (ProcessOutputTypes.STDOUT.equals((Object)outputType) && (event = this.converter.convert(line)) != null) {
            this.beforeHandler(event);
            try {
                this.callHandler(event);
            }
            catch (SVNException e) {
                this.cancel();
                this.exception.set(e);
            }
        }
    }

    private void callHandler(SVNEvent event) throws SVNException {
        if (this.handler != null) {
            this.handler.handleEvent(event, 0.5);
        }
    }

    public void throwIfException() throws SVNException {
        SVNException e = this.exception.get();
        if (e != null) {
            throw e;
        }
    }

    public void throwWrappedIfException() throws VcsException {
        SVNException e = this.exception.get();
        if (e != null) {
            throw new VcsException((Throwable)e);
        }
    }

    protected void beforeHandler(@NotNull SVNEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/BaseUpdateCommandListener", "beforeHandler"));
        }
    }
}

