/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.cleanup;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.cleanup.CleanupClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnKitCleanupClient
extends BaseSvnClient
implements CleanupClient {
    @Override
    public void cleanup(@NotNull File path, @Nullable ISVNEventHandler handler) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/cleanup/SvnKitCleanupClient", "cleanup"));
        }
        SVNWCClient client = this.myVcs.createWCClient();
        client.setEventHandler(handler);
        try {
            client.doCleanup(path);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }
}

