/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractFilterChildren;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.commandLine.SvnCommandLineStatusClient;
import org.jetbrains.idea.svn.commandLine.SvnCommitRunner;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger LOG = Logger.getInstance(SvnCheckinEnvironment.class);
    @NotNull
    private final SvnVcs mySvnVcs;

    public SvnCheckinEnvironment(@NotNull SvnVcs svnVcs) {
        if (svnVcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "<init>"));
        }
        this.mySvnVcs = svnVcs;
    }

    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        return new KeepLocksComponent();
    }

    @Nullable
    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        return null;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    private List<VcsException> commitInt(List<File> paths, final String comment, final boolean force, final Set<String> feedback) {
        final ArrayList<VcsException> exception = new ArrayList<VcsException>();
        final List<File> committables = this.getCommitables(paths);
        final SVNCommitClient committer = this.mySvnVcs.createCommitClient();
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        IdeaCommitHandler handler = new IdeaCommitHandler(progress, true, true);
        if (progress != null) {
            committer.setEventHandler((ISVNEventHandler)handler);
        }
        if (progress != null) {
            this.doCommit(committables, committer, comment, force, exception, feedback);
        } else if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    SvnCheckinEnvironment.this.doCommit(committables, committer, comment, force, exception, feedback);
                }
            }, SvnBundle.message("progress.title.commit", new Object[0]), false, this.mySvnVcs.getProject());
        } else {
            this.doCommit(committables, committer, comment, force, exception, feedback);
        }
        for (VirtualFile f : handler.getDeletedFiles()) {
            f.putUserData(VirtualFile.REQUESTOR_MARKER, (Object)this);
        }
        return exception;
    }

    private void doCommit(List<File> committables, SVNCommitClient committer, String comment, boolean force, List<VcsException> exception, Set<String> feedback) {
        MultiMap<Pair<SVNURL, WorkingCopyFormat>, File> map = SvnUtil.splitIntoRepositoriesMap(this.mySvnVcs, committables, Convertor.SELF);
        for (Map.Entry entry : map.entrySet()) {
            this.doCommitOneRepo((Collection)entry.getValue(), committer, comment, force, exception, feedback, (WorkingCopyFormat)((Object)((Pair)entry.getKey()).getSecond()));
        }
    }

    private void doCommitOneRepo(Collection<File> committables, SVNCommitClient committer, String comment, boolean force, List<VcsException> exception, Set<String> feedback, WorkingCopyFormat format) {
        if (committables.isEmpty()) {
            return;
        }
        if (WorkingCopyFormat.ONE_DOT_EIGHT.equals((Object)format) || !WorkingCopyFormat.ONE_DOT_SIX.equals((Object)format) && this.mySvnVcs.getSvnConfiguration().isCommandLine()) {
            this.doWithCommandLine(committables, comment, exception, feedback);
        } else {
            this.doWithSvnkit(committables, committer, comment, force, exception, feedback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithSvnkit(Collection<File> committables, SVNCommitClient committer, String comment, boolean force, List<VcsException> exception, Set<String> feedback) {
        SVNCommitInfo[] results;
        File[] pathsToCommit = committables.toArray(new File[committables.size()]);
        boolean keepLocks = SvnConfiguration.getInstance(this.mySvnVcs.getProject()).isKeepLocks();
        SVNCommitPacket[] commitPackets = null;
        try {
            commitPackets = committer.doCollectCommitItems(pathsToCommit, keepLocks, force, SVNDepth.EMPTY, true, null);
            results = committer.doCommit(commitPackets, keepLocks, comment);
            commitPackets = null;
        }
        catch (SVNException e) {
            exception.add(new VcsException((Throwable)e));
            LOG.info((Throwable)e);
            return;
        }
        finally {
            if (commitPackets != null) {
                for (SVNCommitPacket commitPacket : commitPackets) {
                    try {
                        commitPacket.dispose();
                    }
                    catch (SVNException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        }
        StringBuilder committedRevisions = new StringBuilder();
        for (SVNCommitInfo result : results) {
            if (result.getErrorMessage() != null) {
                exception.add(new VcsException(result.getErrorMessage().getFullMessage()));
                continue;
            }
            if (result == SVNCommitInfo.NULL || result.getNewRevision() <= 0L) continue;
            if (committedRevisions.length() > 0) {
                committedRevisions.append(", ");
            }
            committedRevisions.append(result.getNewRevision());
        }
        if (committedRevisions.length() > 0) {
            this.reportCommittedRevisions(feedback, committedRevisions.toString());
        }
    }

    private void doWithCommandLine(Collection<File> committables, String comment, List<VcsException> exception, Set<String> feedback) {
        try {
            committables = this.filterCommittables(committables);
        }
        catch (SVNException e) {
            exception.add(new VcsException((Throwable)e));
            return;
        }
        IdeaCommitHandler handler = new IdeaCommitHandler(ProgressManager.getInstance().getProgressIndicator());
        try {
            SvnCommitRunner runner = new SvnCommitRunner(this.mySvnVcs, handler);
            long revision = runner.commit((File[])ArrayUtil.toObjectArray(committables, File.class), comment, SVNDepth.EMPTY, false, false, null, null);
            this.reportCommittedRevisions(feedback, String.valueOf(revision));
        }
        catch (VcsException e) {
            exception.add(e);
        }
    }

    private Collection<File> filterCommittables(Collection<File> committables) throws SVNException {
        final HashSet childrenOfSomebody = ContainerUtil.newHashSet();
        new AbstractFilterChildren<File>(){

            protected void sortAscending(List<File> list) {
                Collections.sort(list);
            }

            protected boolean isAncestor(File parent, File child) {
                boolean isAncestor = FileUtil.isAncestor((File)parent, (File)child, (boolean)true);
                if (isAncestor) {
                    childrenOfSomebody.add(child.getPath());
                }
                return isAncestor;
            }
        }.doFilter(new ArrayList<File>(committables));
        if (!childrenOfSomebody.isEmpty()) {
            ArrayList result = ContainerUtil.newArrayList();
            SvnCommandLineStatusClient statusClient = new SvnCommandLineStatusClient(this.mySvnVcs);
            for (File file : committables) {
                if (!childrenOfSomebody.contains(file.getPath())) {
                    result.add(file);
                    continue;
                }
                try {
                    SVNStatus status = statusClient.doStatus(file, false);
                    if (status == null || SVNStatusType.STATUS_NONE.equals(status.getContentsStatus()) || SVNStatusType.STATUS_UNVERSIONED.equals(status.getContentsStatus())) continue;
                    result.add(file);
                }
                catch (SVNException e) {
                    LOG.info((Throwable)e);
                    throw e;
                }
            }
            return result;
        }
        return committables;
    }

    private void reportCommittedRevisions(Set<String> feedback, String committedRevisions) {
        final Project project = this.mySvnVcs.getProject();
        final String message = SvnBundle.message("status.text.comitted.revision", committedRevisions);
        if (feedback == null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    new VcsBalloonProblemNotifier(project, message, MessageType.INFO).run();
                }
            }, (Condition)new Condition<Object>(){

                public boolean value(Object o) {
                    return !project.isOpen() || project.isDisposed();
                }
            });
        } else {
            feedback.add("Subversion: " + message);
        }
    }

    private List<File> getCommitables(List<File> paths) {
        Adder adder = new Adder();
        for (File path : paths) {
            File file = path.getAbsoluteFile();
            adder.add(file);
            if (file.getParentFile() == null) continue;
            this.addParents(file.getParentFile(), adder);
        }
        return adder.getResult();
    }

    private void addParents(File file, Adder adder) {
        SVNStatus status = this.getStatus(file);
        if (status != null && (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_ADDED) || SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_REPLACED))) {
            adder.add(file);
            file = file.getParentFile();
            if (file != null) {
                this.addParents(file, adder);
            }
        }
    }

    @Nullable
    private SVNStatus getStatus(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "getStatus"));
        }
        SVNStatus result = null;
        try {
            result = this.mySvnVcs.getFactory(file).createStatusClient().doStatus(file, false);
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
        }
        return result;
    }

    private static List<File> collectPaths(@NotNull List<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "collectPaths"));
        }
        HashSet paths = ContainerUtil.newHashSet();
        for (Change change : changes) {
            SvnCheckinEnvironment.addPath(paths, change.getBeforeRevision());
            SvnCheckinEnvironment.addPath(paths, change.getAfterRevision());
        }
        return SvnUtil.toFiles(paths);
    }

    private static void addPath(@NotNull Collection<String> paths, @Nullable ContentRevision revision) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "addPath"));
        }
        if (revision != null) {
            paths.add(revision.getFile().getIOFile().getAbsolutePath());
        }
    }

    public String getCheckinOperationName() {
        return SvnBundle.message("checkin.operation.name", new Object[0]);
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        if (parametersHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "commit"));
        }
        return this.commitInt(SvnCheckinEnvironment.collectPaths(changes), preparedComment, true, feedback);
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> filePaths) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        List files = ChangesUtil.filePathsToFiles(filePaths);
        for (File file : files) {
            try {
                this.mySvnVcs.getFactory(file).createDeleteClient().delete(file, true, false, null);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        return SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(this.mySvnVcs, files);
    }

    public static List<VcsException> scheduleUnversionedFilesForAddition(@NotNull SvnVcs vcs, List<VirtualFile> files) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "scheduleUnversionedFilesForAddition"));
        }
        return SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(vcs, files, false);
    }

    public static List<VcsException> scheduleUnversionedFilesForAddition(@NotNull SvnVcs vcs, List<VirtualFile> files, boolean recursive) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "scheduleUnversionedFilesForAddition"));
        }
        Collections.sort(files, FilePathComparator.getInstance());
        SvnProgressCanceller eventHandler = new SvnProgressCanceller(){

            @Override
            public void handleEvent(SVNEvent event, double progress) throws SVNException {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                File file = event.getFile();
                if (indicator != null && file != null) {
                    indicator.setText(SvnBundle.message("progress.text2.adding", file.getName() + " (" + file.getParent() + ")"));
                }
            }
        };
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        SVNDepth depth = recursive ? SVNDepth.INFINITY : SVNDepth.EMPTY;
        for (VirtualFile file : files) {
            try {
                File convertedFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                vcs.getFactory(convertedFile).createAddClient().add(convertedFile, depth, true, false, true, eventHandler);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    private class KeepLocksComponent
    implements RefreshableOnComponent {
        @NotNull
        private final JCheckBox myKeepLocksBox;
        private boolean myIsKeepLocks;
        @NotNull
        private final JPanel myPanel = new JPanel(new BorderLayout());
        @NotNull
        private final JCheckBox myAutoUpdate;

        public KeepLocksComponent() {
            this.myKeepLocksBox = new JCheckBox(SvnBundle.message("checkbox.chckin.keep.files.locked", new Object[0]));
            this.myKeepLocksBox.setSelected(this.myIsKeepLocks);
            this.myAutoUpdate = new JCheckBox("Auto-update after commit");
            this.myPanel.add((Component)this.myAutoUpdate, "North");
            this.myPanel.add((Component)this.myKeepLocksBox, "Center");
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public boolean isKeepLocks() {
            return this.myKeepLocksBox.isSelected();
        }

        public boolean isAutoUpdate() {
            return this.myAutoUpdate.isSelected();
        }

        public void refresh() {
        }

        public void saveState() {
            SvnConfiguration configuration = SvnCheckinEnvironment.this.mySvnVcs.getSvnConfiguration();
            configuration.setKeepLocks(this.isKeepLocks());
            configuration.setAutoUpdateAfterCommit(this.isAutoUpdate());
        }

        public void restoreState() {
            SvnConfiguration configuration = SvnCheckinEnvironment.this.mySvnVcs.getSvnConfiguration();
            this.myIsKeepLocks = configuration.isKeepLocks();
            this.myAutoUpdate.setSelected(configuration.isAutoUpdateAfterCommit());
        }
    }

    private static class Adder {
        private final List<File> myResult = new ArrayList<File>();
        private final Set<String> myDuplicatesControlSet = new HashSet<String>();

        private Adder() {
        }

        public void add(File file) {
            String path = file.getAbsolutePath();
            if (!this.myDuplicatesControlSet.contains(path)) {
                this.myResult.add(file);
                this.myDuplicatesControlSet.add(path);
            }
        }

        public List<File> getResult() {
            return this.myResult;
        }
    }
}

