/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.commandLine.CommitEventHandler;
import org.jetbrains.idea.svn.commandLine.CommitEventType;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

public class IdeaCommitHandler
implements CommitEventHandler,
ISVNEventHandler {
    private static final Logger LOG = Logger.getInstance(IdeaCommitHandler.class);
    @Nullable
    private final ProgressIndicator myProgress;
    @NotNull
    private final List<VirtualFile> myDeletedFiles = ContainerUtil.newArrayList();
    private final boolean myCheckCancel;
    private final boolean myTrackDeletedFiles;

    public IdeaCommitHandler(@Nullable ProgressIndicator progress) {
        this(progress, false, false);
    }

    public IdeaCommitHandler(@Nullable ProgressIndicator progress, boolean checkCancel, boolean trackDeletedFiles) {
        this.myProgress = progress;
        this.myCheckCancel = checkCancel;
        this.myTrackDeletedFiles = trackDeletedFiles;
    }

    @NotNull
    public List<VirtualFile> getDeletedFiles() {
        List<VirtualFile> list = this.myDeletedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "getDeletedFiles"));
        }
        return list;
    }

    @Override
    public void commitEvent(CommitEventType type, File target) {
        if (this.myProgress == null) {
            return;
        }
        this.myProgress.checkCanceled();
        this.updateProgress(type, target.getPath());
    }

    @Override
    public void committedRevision(long revNum) {
        if (this.myProgress == null) {
            return;
        }
        this.myProgress.checkCanceled();
        this.myProgress.setText2(SvnBundle.message("status.text.comitted.revision", revNum));
    }

    public void handleEvent(SVNEvent event, double p) {
        String path = SvnUtil.getPathForProgress(event);
        if (path != null) {
            CommitEventType eventType = IdeaCommitHandler.convert(event.getAction());
            if (CommitEventType.deleting.equals((Object)eventType) && this.myTrackDeletedFiles) {
                this.trackDeletedFile(event);
            }
            this.updateProgress(eventType, path);
        }
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.myCheckCancel && this.myProgress != null) {
            try {
                this.myProgress.checkCanceled();
            }
            catch (ProcessCanceledException ex) {
                throw new SVNCancelException();
            }
        }
    }

    private void updateProgress(@NotNull CommitEventType type, @NotNull String target) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "updateProgress"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "updateProgress"));
        }
        if (this.myProgress == null) {
            return;
        }
        if (CommitEventType.adding.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.adding", target));
        } else if (CommitEventType.deleting.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.deleting", target));
        } else if (CommitEventType.sending.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.sending", target));
        } else if (CommitEventType.replacing.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.replacing", target));
        } else if (CommitEventType.transmittingDeltas.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.transmitting.delta", target));
        }
    }

    private void trackDeletedFile(@NotNull SVNEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "trackDeletedFile"));
        }
        final String filePath = "file://" + event.getFile().getAbsolutePath().replace(File.separatorChar, '/');
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            @Nullable
            public VirtualFile compute() {
                return VirtualFileManager.getInstance().findFileByUrl(filePath);
            }
        });
        if (virtualFile != null) {
            this.myDeletedFiles.add(virtualFile);
        }
    }

    @NotNull
    private static CommitEventType convert(@NotNull SVNEventAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "convert"));
        }
        CommitEventType result = CommitEventType.unknown;
        if (SVNEventAction.COMMIT_ADDED.equals(action)) {
            result = CommitEventType.adding;
        } else if (SVNEventAction.COMMIT_DELETED.equals(action)) {
            result = CommitEventType.deleting;
        } else if (SVNEventAction.COMMIT_MODIFIED.equals(action)) {
            result = CommitEventType.sending;
        } else if (SVNEventAction.COMMIT_REPLACED.equals(action)) {
            result = CommitEventType.replacing;
        } else if (SVNEventAction.COMMIT_DELTA_SENT.equals(action)) {
            result = CommitEventType.transmittingDeltas;
        } else if (SVNEventAction.SKIP.equals(action)) {
            result = CommitEventType.skipped;
        } else if (SVNEventAction.FAILED_OUT_OF_DATE.equals(action)) {
            result = CommitEventType.failedOutOfDate;
        }
        if (CommitEventType.unknown.equals((Object)result)) {
            LOG.warn("Could not create commit event from action " + action);
        }
        CommitEventType commitEventType = result;
        if (commitEventType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "convert"));
        }
        return commitEventType;
    }
}

