/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.browse;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitBrowseClient
extends BaseSvnClient
implements BrowseClient {
    @Override
    public void list(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable SVNDepth depth, @Nullable ISVNDirEntryHandler handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/browse/SvnKitBrowseClient", "list"));
        }
        this.assertUrl(target);
        SVNLogClient client = this.myVcs.createLogClient();
        ISVNDirEntryHandler wrappedHandler = SvnKitBrowseClient.wrapHandler(handler);
        try {
            if (target.isFile()) {
                client.doList(target.getFile(), target.getPegRevision(), revision, true, depth, -1, wrappedHandler);
            } else {
                client.doList(target.getURL(), target.getPegRevision(), revision, true, depth, -1, wrappedHandler);
            }
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Nullable
    private static ISVNDirEntryHandler wrapHandler(@Nullable ISVNDirEntryHandler handler) {
        return handler == null ? null : new SkipEmptyNameDirectoriesHandler(handler);
    }

    public static class SkipEmptyNameDirectoriesHandler
    implements ISVNDirEntryHandler {
        @NotNull
        private final ISVNDirEntryHandler handler;

        public SkipEmptyNameDirectoriesHandler(@NotNull ISVNDirEntryHandler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/browse/SvnKitBrowseClient$SkipEmptyNameDirectoriesHandler", "<init>"));
            }
            this.handler = handler;
        }

        public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
            if (!SkipEmptyNameDirectoriesHandler.isEmptyNameDirectory(dirEntry)) {
                this.handler.handleDirEntry(dirEntry);
            }
        }

        private static boolean isEmptyNameDirectory(SVNDirEntry dirEntry) {
            return SVNNodeKind.DIR.equals(dirEntry.getKind()) && StringUtil.isEmpty((String)dirEntry.getName());
        }
    }
}

