/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManagerQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.branchConfig.BranchesLoader;
import org.jetbrains.idea.svn.branchConfig.DefaultConfigLoader;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.integrate.SvnBranchItem;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class NewRootBunch
implements SvnBranchConfigManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.branchConfig.NewRootBunch");
    private final Object myLock = new Object();
    private final Project myProject;
    private final ProgressManagerQueue myBranchesLoader;
    private final Map<VirtualFile, InfoStorage<SvnBranchConfigurationNew>> myMap;

    public NewRootBunch(Project project, ProgressManagerQueue branchesLoader) {
        this.myProject = project;
        this.myBranchesLoader = branchesLoader;
        this.myMap = new HashMap<VirtualFile, InfoStorage<SvnBranchConfigurationNew>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateForRoot(@NotNull VirtualFile root, @NotNull InfoStorage<SvnBranchConfigurationNew> config, @Nullable PairConsumer<SvnBranchConfigurationNew, SvnBranchConfigurationNew> callbackOnUpdate) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "updateForRoot"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "updateForRoot"));
        }
        Object object = this.myLock;
        synchronized (object) {
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                this.myMap.put(root, config);
                if (callbackOnUpdate != null) {
                    callbackOnUpdate.consume(null, (Object)config.getValue());
                }
            } else {
                existing.accept(config, callbackOnUpdate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBranches(@NotNull VirtualFile root, @NotNull String branchesParent, @NotNull InfoStorage<List<SvnBranchItem>> items) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "updateBranches"));
        }
        if (branchesParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "updateBranches"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "updateBranches"));
        }
        Object object = this.myLock;
        synchronized (object) {
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                LOG.info("cannot update branches, branches parent not found: " + branchesParent);
            } else {
                existing.getValue().updateBranch(branchesParent, items);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public SvnBranchConfigurationNew getConfig(@NotNull VirtualFile root) {
        SvnBranchConfigurationNew result;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "getConfig"));
        }
        Object object = this.myLock;
        // MONITORENTER : object
        InfoStorage<SvnBranchConfigurationNew> value = this.myMap.get(root);
        if (value == null) {
            result = new SvnBranchConfigurationNew();
            this.myMap.put(root, new InfoStorage<SvnBranchConfigurationNew>(result, InfoReliability.empty));
            this.myBranchesLoader.run((Object)new DefaultBranchConfigInitializer(this.myProject, this, root));
        } else {
            result = value.getValue();
        }
        SvnBranchConfigurationNew svnBranchConfigurationNew = result;
        // MONITOREXIT : object
        if (svnBranchConfigurationNew != null) return svnBranchConfigurationNew;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "getConfig"));
    }

    @Override
    public void reloadBranches(@NotNull VirtualFile root, @NotNull String branchParentUrl, Consumer<List<SvnBranchItem>> callback) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "reloadBranches"));
        }
        if (branchParentUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/branchConfig/NewRootBunch", "reloadBranches"));
        }
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new BranchesLoadRunnable(this.myProject, this, branchParentUrl, InfoReliability.setByUser, root, callback, true));
    }

    @Override
    @Nullable
    public SVNURL getWorkingBranchWithReload(final SVNURL svnurl, final VirtualFile root) {
        final Ref result = new Ref();
        try {
            SvnBranchConfigurationNew configuration = this.myMap.get(root).getValue();
            String group = configuration.getGroupToLoadToReachUrl(svnurl);
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SvnBranchConfigurationNew reloadedConfiguration = (SvnBranchConfigurationNew)((InfoStorage)NewRootBunch.this.myMap.get(root)).getValue();
                    try {
                        result.set((Object)reloadedConfiguration.getWorkingBranch(svnurl));
                    }
                    catch (SVNException sVNException) {
                        // empty catch block
                    }
                }
            };
            if (group == null) {
                runnable.run();
            } else {
                new BranchesLoadRunnable(this.myProject, this, group, InfoReliability.setByUser, root, new Consumer<List<SvnBranchItem>>(){

                    public void consume(List<SvnBranchItem> svnBranchItems) {
                        runnable.run();
                    }
                }, true).run();
            }
        }
        catch (SVNException e) {
            // empty catch block
        }
        return (SVNURL)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<VirtualFile, SvnBranchConfigurationNew> getMapCopy() {
        Object object = this.myLock;
        synchronized (object) {
            HashMap<VirtualFile, SvnBranchConfigurationNew> result = new HashMap<VirtualFile, SvnBranchConfigurationNew>();
            for (VirtualFile vf : this.myMap.keySet()) {
                result.put(vf, this.myMap.get(vf).getValue());
            }
            return result;
        }
    }

    private static class DefaultBranchConfigInitializer
    implements Runnable {
        private final Project myProject;
        private final SvnBranchConfigManager myBunch;
        private final VirtualFile myRoot;

        private DefaultBranchConfigInitializer(Project project, SvnBranchConfigManager bunch, VirtualFile root) {
            this.myProject = project;
            this.myRoot = root;
            this.myBunch = bunch;
        }

        @Override
        public void run() {
            SvnBranchConfigurationNew result = DefaultConfigLoader.loadDefaultConfiguration(this.myProject, this.myRoot);
            if (result != null) {
                Application application = ApplicationManager.getApplication();
                for (String url : result.getBranchUrls()) {
                    application.executeOnPooledThread((Runnable)new BranchesLoadRunnable(this.myProject, this.myBunch, url, InfoReliability.defaultValues, this.myRoot, null, true));
                }
                this.myBunch.updateForRoot(this.myRoot, new InfoStorage<SvnBranchConfigurationNew>(result, InfoReliability.defaultValues), null);
            }
        }
    }

    public static class BranchesLoadRunnable
    implements Runnable {
        private final Project myProject;
        private final SvnBranchConfigManager myBunch;
        private final VirtualFile myRoot;
        @Nullable
        private final Consumer<List<SvnBranchItem>> myCallback;
        private final String myUrl;
        private final InfoReliability myInfoReliability;
        private boolean myPassive;

        public BranchesLoadRunnable(Project project, SvnBranchConfigManager bunch, String url, InfoReliability infoReliability, VirtualFile root, @Nullable Consumer<List<SvnBranchItem>> callback, boolean passive) {
            this.myProject = project;
            this.myBunch = bunch;
            this.myUrl = url;
            this.myInfoReliability = infoReliability;
            this.myRoot = root;
            this.myCallback = callback;
            this.myPassive = passive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean callbackCalled = false;
            try {
                List<SvnBranchItem> items = BranchesLoader.loadBranches(this.myProject, this.myUrl, this.myPassive);
                this.myBunch.updateBranches(this.myRoot, this.myUrl, new InfoStorage<List<SvnBranchItem>>(items, this.myInfoReliability));
                if (this.myCallback != null) {
                    this.myCallback.consume(items);
                    callbackCalled = true;
                }
            }
            catch (VcsException e) {
                this.showError((Exception)((Object)e));
            }
            catch (SVNException e) {
                this.showError((Exception)((Object)e));
            }
            finally {
                if (this.myCallback != null && !callbackCalled) {
                    this.myCallback.consume(null);
                }
            }
        }

        private void showError(Exception e) {
            if (InfoReliability.setByUser.equals((Object)this.myInfoReliability)) {
                VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)("Branches load error: " + e.getMessage()), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
            }
        }
    }
}

