/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.integrate.SvnBranchItem;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class DefaultConfigLoader {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.branchConfig.DefaultConfigLoader");
    @NonNls
    private static final String DEFAULT_TRUNK_NAME = "trunk";
    @NonNls
    private static final String DEFAULT_BRANCHES_NAME = "branches";
    @NonNls
    private static final String DEFAULT_TAGS_NAME = "tags";

    private DefaultConfigLoader() {
    }

    @Nullable
    public static SvnBranchConfigurationNew loadDefaultConfiguration(Project project, VirtualFile vcsRoot) {
        try {
            SvnVcs vcs = SvnVcs.getInstance(project);
            File rootFile = new File(vcsRoot.getPath());
            SVNInfo info = vcs.getInfo(rootFile);
            if (info == null || info.getURL() == null) {
                LOG.info("Directory is not a working copy: " + vcsRoot.getPresentableUrl());
                return null;
            }
            SVNURL baseUrl = info.getURL();
            final SvnBranchConfigurationNew result = new SvnBranchConfigurationNew();
            result.setTrunkUrl(baseUrl.toString());
            while (true) {
                String s;
                if ((s = SVNPathUtil.tail((String)baseUrl.getPath())).equalsIgnoreCase(DEFAULT_TRUNK_NAME) || s.equalsIgnoreCase(DEFAULT_BRANCHES_NAME) || s.equalsIgnoreCase(DEFAULT_TAGS_NAME)) {
                    final SVNURL rootPath = baseUrl.removePathTail();
                    SVNLogClient client = vcs.createLogClient();
                    client.doList(rootPath, SVNRevision.UNDEFINED, SVNRevision.HEAD, false, false, new ISVNDirEntryHandler(){

                        public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                            if ("".equals(dirEntry.getRelativePath()) || !SVNNodeKind.DIR.equals(dirEntry.getKind())) {
                                return;
                            }
                            if (dirEntry.getName().toLowerCase().endsWith(DefaultConfigLoader.DEFAULT_TRUNK_NAME)) {
                                result.setTrunkUrl(rootPath.appendPath(dirEntry.getName(), false).toString());
                            } else {
                                result.addBranches(rootPath.appendPath(dirEntry.getName(), false).toString(), new InfoStorage<List<SvnBranchItem>>(new ArrayList(0), InfoReliability.defaultValues));
                            }
                        }
                    });
                    break;
                }
                if (SVNPathUtil.removeTail((String)baseUrl.getPath()).length() == 0) break;
                baseUrl = baseUrl.removePathTail();
            }
            return result;
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }
}

