/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.integrate.SvnBranchItem;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class BranchesLoader {
    private BranchesLoader() {
    }

    public static List<SvnBranchItem> loadBranches(Project project, String url, boolean passive) throws SVNException, VcsException {
        SvnConfiguration configuration = SvnConfiguration.getInstance(project);
        SvnVcs vcs = SvnVcs.getInstance(project);
        SVNURL branchesUrl = SVNURL.parseURIEncoded((String)url);
        LinkedList<SvnBranchItem> result = new LinkedList<SvnBranchItem>();
        SvnTarget target = SvnTarget.fromURL((SVNURL)branchesUrl);
        ISVNDirEntryHandler handler = BranchesLoader.createHandler(branchesUrl, result);
        if (!passive) {
            vcs.getFactory(target).createBrowseClient().list(target, SVNRevision.HEAD, SVNDepth.IMMEDIATES, handler);
        } else {
            SVNLogClient client = vcs.createLogClient((ISVNAuthenticationManager)configuration.getPassiveAuthenticationManager(project));
            client.doList(target.getURL(), target.getPegRevision(), SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, -1, handler);
        }
        Collections.sort(result);
        return result;
    }

    @NotNull
    private static ISVNDirEntryHandler createHandler(final @NotNull SVNURL branchesUrl, final @NotNull List<SvnBranchItem> result) {
        if (branchesUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "createHandler"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "createHandler"));
        }
        ISVNDirEntryHandler iSVNDirEntryHandler = new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                if (!branchesUrl.equals((Object)dirEntry.getURL()) && dirEntry.getDate() != null) {
                    result.add(new SvnBranchItem(dirEntry.getURL().toDecodedString(), dirEntry.getDate(), dirEntry.getRevision()));
                }
            }
        };
        if (iSVNDirEntryHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/BranchesLoader", "createHandler"));
        }
        return iSVNDirEntryHandler;
    }
}

