/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.add.SvnKitAddClient;
import org.jetbrains.idea.svn.annotate.SvnKitAnnotateClient;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.SvnKitVersionClient;
import org.jetbrains.idea.svn.browse.SvnKitBrowseClient;
import org.jetbrains.idea.svn.change.SvnKitChangeListClient;
import org.jetbrains.idea.svn.checkin.SvnKitImportClient;
import org.jetbrains.idea.svn.checkout.SvnKitCheckoutClient;
import org.jetbrains.idea.svn.checkout.SvnKitExportClient;
import org.jetbrains.idea.svn.cleanup.SvnKitCleanupClient;
import org.jetbrains.idea.svn.conflict.SvnKitConflictClient;
import org.jetbrains.idea.svn.content.SvnKitContentClient;
import org.jetbrains.idea.svn.copy.SvnKitCopyMoveClient;
import org.jetbrains.idea.svn.delete.SvnKitDeleteClient;
import org.jetbrains.idea.svn.diff.SvnKitDiffClient;
import org.jetbrains.idea.svn.history.SvnKitHistoryClient;
import org.jetbrains.idea.svn.integrate.SvnKitMergeClient;
import org.jetbrains.idea.svn.lock.SvnKitLockClient;
import org.jetbrains.idea.svn.portable.SvnkitSvnStatusClient;
import org.jetbrains.idea.svn.portable.SvnkitSvnWcClient;
import org.jetbrains.idea.svn.properties.SvnKitPropertyClient;
import org.jetbrains.idea.svn.revert.SvnKitRevertClient;
import org.jetbrains.idea.svn.update.SvnKitRelocateClient;
import org.jetbrains.idea.svn.update.SvnKitUpdateClient;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.jetbrains.idea.svn.upgrade.SvnKitUpgradeClient;

public class SvnKitClientFactory
extends ClientFactory {
    public SvnKitClientFactory(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/SvnKitClientFactory", "<init>"));
        }
        super(vcs);
    }

    @Override
    protected void setup() {
        this.addClient = new SvnKitAddClient();
        this.annotateClient = new SvnKitAnnotateClient();
        this.contentClient = new SvnKitContentClient();
        this.historyClient = new SvnKitHistoryClient();
        this.revertClient = new SvnKitRevertClient();
        this.deleteClient = new SvnKitDeleteClient();
        this.copyMoveClient = new SvnKitCopyMoveClient();
        this.conflictClient = new SvnKitConflictClient();
        this.propertyClient = new SvnKitPropertyClient();
        this.mergeClient = new SvnKitMergeClient();
        this.changeListClient = new SvnKitChangeListClient();
        this.checkoutClient = new SvnKitCheckoutClient();
        this.myLockClient = new SvnKitLockClient();
        this.myCleanupClient = new SvnKitCleanupClient();
        this.myRelocateClient = new SvnKitRelocateClient();
        this.myVersionClient = new SvnKitVersionClient();
        this.myImportClient = new SvnKitImportClient();
        this.myExportClient = new SvnKitExportClient();
        this.myUpgradeClient = new SvnKitUpgradeClient();
        this.myBrowseClient = new SvnKitBrowseClient();
        this.myDiffClient = new SvnKitDiffClient();
        this.statusClient = new SvnkitSvnStatusClient(this.myVcs, null);
        this.infoClient = new SvnkitSvnWcClient(this.myVcs);
    }

    @Override
    @NotNull
    public UpdateClient createUpdateClient() {
        UpdateClient updateClient = this.prepare(new SvnKitUpdateClient());
        if (updateClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/SvnKitClientFactory", "createUpdateClient"));
        }
        return updateClient;
    }
}

