/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.Convertor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;

public class FileStatusResultParser {
    private static final double DEFAULT_PROGRESS = 0.0;
    @NotNull
    private Pattern myLinePattern;
    @Nullable
    private ISVNEventHandler handler;
    @NotNull
    private Convertor<Matcher, SVNEvent> myConvertor;

    public FileStatusResultParser(@NotNull Pattern linePattern, @Nullable ISVNEventHandler handler, @NotNull Convertor<Matcher, SVNEvent> convertor) {
        if (linePattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/FileStatusResultParser", "<init>"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/api/FileStatusResultParser", "<init>"));
        }
        this.myLinePattern = linePattern;
        this.handler = handler;
        this.myConvertor = convertor;
    }

    public void parse(@NotNull String output) throws VcsException {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/FileStatusResultParser", "parse"));
        }
        if (StringUtil.isEmpty((String)output)) {
            return;
        }
        for (String line : StringUtil.splitByLines((String)output)) {
            this.onLine(line);
        }
    }

    public void onLine(@NotNull String line) throws VcsException {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/FileStatusResultParser", "onLine"));
        }
        Matcher matcher = this.myLinePattern.matcher(line);
        if (!matcher.matches()) {
            throw new VcsException("unknown state on line " + line);
        }
        this.process(matcher);
    }

    public void process(@NotNull Matcher matcher) throws VcsException {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/FileStatusResultParser", "process"));
        }
        if (this.handler != null) {
            try {
                this.handler.handleEvent((SVNEvent)this.myConvertor.convert((Object)matcher), 0.0);
            }
            catch (SVNException e) {
                throw new VcsException((Throwable)e);
            }
        }
    }
}

