/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.vcs.VcsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.VersionClient;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;

public class CmdVersionClient
extends BaseSvnClient
implements VersionClient {
    private static final Pattern VERSION = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)");

    @Override
    @NotNull
    public Version getVersion() throws VcsException {
        Version version = CmdVersionClient.parseVersion(CmdVersionClient.runCommand());
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/CmdVersionClient", "getVersion"));
        }
        return version;
    }

    private static ProcessOutput runCommand() throws SvnBindException {
        Command command = new Command(SvnCommandName.version);
        command.put("--quiet");
        CommandExecutor executor = new CommandExecutor(SvnApplicationSettings.getInstance().getCommandLinePath(), command);
        executor.run(30000);
        return executor.getProcessOutput();
    }

    @NotNull
    private static Version parseVersion(@NotNull ProcessOutput output) throws VcsException {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/CmdVersionClient", "parseVersion"));
        }
        if (output.isTimeout() || output.getExitCode() != 0 || !output.getStderr().isEmpty()) {
            throw new VcsException(String.format("Exit code: %d, Error: %s, Timeout: %b", output.getExitCode(), output.getStderr(), output.isTimeout()));
        }
        Version version = CmdVersionClient.parseVersion(output.getStdout());
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/CmdVersionClient", "parseVersion"));
        }
        return version;
    }

    @NotNull
    public static Version parseVersion(@NotNull String versionText) throws VcsException {
        if (versionText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/CmdVersionClient", "parseVersion"));
        }
        Version result = null;
        NumberFormatException cause = null;
        Matcher matcher = VERSION.matcher(versionText);
        boolean found = matcher.find();
        if (found) {
            try {
                result = new Version(CmdVersionClient.getInt(matcher.group(1)), CmdVersionClient.getInt(matcher.group(2)), CmdVersionClient.getInt(matcher.group(3)));
            }
            catch (NumberFormatException e) {
                cause = e;
            }
        }
        if (!found || cause != null) {
            throw new VcsException(String.format("Could not parse svn version: %s", versionText), (Throwable)cause);
        }
        Version version = result;
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/CmdVersionClient", "parseVersion"));
        }
        return version;
    }

    private static int getInt(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/CmdVersionClient", "getInt"));
        }
        return Integer.parseInt(value);
    }
}

