/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.add.AddClient;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.api.SvnClient;
import org.jetbrains.idea.svn.api.VersionClient;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.change.ChangeListClient;
import org.jetbrains.idea.svn.checkin.ImportClient;
import org.jetbrains.idea.svn.checkout.CheckoutClient;
import org.jetbrains.idea.svn.checkout.ExportClient;
import org.jetbrains.idea.svn.cleanup.CleanupClient;
import org.jetbrains.idea.svn.conflict.ConflictClient;
import org.jetbrains.idea.svn.content.ContentClient;
import org.jetbrains.idea.svn.copy.CopyMoveClient;
import org.jetbrains.idea.svn.delete.DeleteClient;
import org.jetbrains.idea.svn.diff.DiffClient;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.lock.LockClient;
import org.jetbrains.idea.svn.portable.SvnStatusClientI;
import org.jetbrains.idea.svn.portable.SvnWcClientI;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.revert.RevertClient;
import org.jetbrains.idea.svn.update.RelocateClient;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.jetbrains.idea.svn.upgrade.UpgradeClient;

public abstract class ClientFactory {
    @NotNull
    protected SvnVcs myVcs;
    protected AddClient addClient;
    protected AnnotateClient annotateClient;
    protected ContentClient contentClient;
    protected HistoryClient historyClient;
    protected RevertClient revertClient;
    protected DeleteClient deleteClient;
    protected SvnStatusClientI statusClient;
    protected SvnWcClientI infoClient;
    protected CopyMoveClient copyMoveClient;
    protected ConflictClient conflictClient;
    protected PropertyClient propertyClient;
    protected MergeClient mergeClient;
    protected ChangeListClient changeListClient;
    protected CheckoutClient checkoutClient;
    protected LockClient myLockClient;
    protected CleanupClient myCleanupClient;
    protected RelocateClient myRelocateClient;
    protected VersionClient myVersionClient;
    protected ImportClient myImportClient;
    protected ExportClient myExportClient;
    protected UpgradeClient myUpgradeClient;
    protected BrowseClient myBrowseClient;
    protected DiffClient myDiffClient;

    protected ClientFactory(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/ClientFactory", "<init>"));
        }
        this.myVcs = vcs;
        this.setup();
    }

    protected abstract void setup();

    @NotNull
    public AddClient createAddClient() {
        AddClient addClient = this.prepare(this.addClient);
        if (addClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createAddClient"));
        }
        return addClient;
    }

    @NotNull
    public AnnotateClient createAnnotateClient() {
        AnnotateClient annotateClient = this.prepare(this.annotateClient);
        if (annotateClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createAnnotateClient"));
        }
        return annotateClient;
    }

    @NotNull
    public ContentClient createContentClient() {
        ContentClient contentClient = this.prepare(this.contentClient);
        if (contentClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createContentClient"));
        }
        return contentClient;
    }

    @NotNull
    public HistoryClient createHistoryClient() {
        HistoryClient historyClient = this.prepare(this.historyClient);
        if (historyClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createHistoryClient"));
        }
        return historyClient;
    }

    @NotNull
    public RevertClient createRevertClient() {
        RevertClient revertClient = this.prepare(this.revertClient);
        if (revertClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createRevertClient"));
        }
        return revertClient;
    }

    @NotNull
    public SvnStatusClientI createStatusClient() {
        SvnStatusClientI svnStatusClientI = this.statusClient;
        if (svnStatusClientI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createStatusClient"));
        }
        return svnStatusClientI;
    }

    @NotNull
    public SvnWcClientI createInfoClient() {
        SvnWcClientI svnWcClientI = this.infoClient;
        if (svnWcClientI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createInfoClient"));
        }
        return svnWcClientI;
    }

    @NotNull
    public abstract UpdateClient createUpdateClient();

    @NotNull
    public DeleteClient createDeleteClient() {
        DeleteClient deleteClient = this.prepare(this.deleteClient);
        if (deleteClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createDeleteClient"));
        }
        return deleteClient;
    }

    @NotNull
    public CopyMoveClient createCopyMoveClient() {
        CopyMoveClient copyMoveClient = this.prepare(this.copyMoveClient);
        if (copyMoveClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createCopyMoveClient"));
        }
        return copyMoveClient;
    }

    @NotNull
    public ConflictClient createConflictClient() {
        ConflictClient conflictClient = this.prepare(this.conflictClient);
        if (conflictClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createConflictClient"));
        }
        return conflictClient;
    }

    @NotNull
    public PropertyClient createPropertyClient() {
        PropertyClient propertyClient = this.prepare(this.propertyClient);
        if (propertyClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createPropertyClient"));
        }
        return propertyClient;
    }

    @NotNull
    public MergeClient createMergeClient() {
        MergeClient mergeClient = this.prepare(this.mergeClient);
        if (mergeClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createMergeClient"));
        }
        return mergeClient;
    }

    @NotNull
    public ChangeListClient createChangeListClient() {
        ChangeListClient changeListClient = this.prepare(this.changeListClient);
        if (changeListClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createChangeListClient"));
        }
        return changeListClient;
    }

    @NotNull
    public CheckoutClient createCheckoutClient() {
        CheckoutClient checkoutClient = this.prepare(this.checkoutClient);
        if (checkoutClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createCheckoutClient"));
        }
        return checkoutClient;
    }

    @NotNull
    public LockClient createLockClient() {
        LockClient lockClient = this.prepare(this.myLockClient);
        if (lockClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createLockClient"));
        }
        return lockClient;
    }

    @NotNull
    public CleanupClient createCleanupClient() {
        CleanupClient cleanupClient = this.prepare(this.myCleanupClient);
        if (cleanupClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createCleanupClient"));
        }
        return cleanupClient;
    }

    @NotNull
    public RelocateClient createRelocateClient() {
        RelocateClient relocateClient = this.prepare(this.myRelocateClient);
        if (relocateClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createRelocateClient"));
        }
        return relocateClient;
    }

    @NotNull
    public VersionClient createVersionClient() {
        VersionClient versionClient = this.prepare(this.myVersionClient);
        if (versionClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createVersionClient"));
        }
        return versionClient;
    }

    @NotNull
    public ImportClient createImportClient() {
        ImportClient importClient = this.prepare(this.myImportClient);
        if (importClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createImportClient"));
        }
        return importClient;
    }

    @NotNull
    public ExportClient createExportClient() {
        ExportClient exportClient = this.prepare(this.myExportClient);
        if (exportClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createExportClient"));
        }
        return exportClient;
    }

    @NotNull
    public UpgradeClient createUpgradeClient() {
        UpgradeClient upgradeClient = this.prepare(this.myUpgradeClient);
        if (upgradeClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createUpgradeClient"));
        }
        return upgradeClient;
    }

    @NotNull
    public BrowseClient createBrowseClient() {
        BrowseClient browseClient = this.prepare(this.myBrowseClient);
        if (browseClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createBrowseClient"));
        }
        return browseClient;
    }

    @NotNull
    public DiffClient createDiffClient() {
        DiffClient diffClient = this.prepare(this.myDiffClient);
        if (diffClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createDiffClient"));
        }
        return diffClient;
    }

    @NotNull
    protected <T extends SvnClient> T prepare(@NotNull T client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/ClientFactory", "prepare"));
        }
        client.setVcs(this.myVcs);
        client.setFactory(this);
        T t = client;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "prepare"));
        }
        return t;
    }
}

