/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.SvnClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public abstract class BaseSvnClient
implements SvnClient {
    protected SvnVcs myVcs;
    protected ClientFactory myFactory;

    @Override
    @NotNull
    public SvnVcs getVcs() {
        SvnVcs svnVcs = this.myVcs;
        if (svnVcs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "getVcs"));
        }
        return svnVcs;
    }

    @Override
    public void setVcs(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/BaseSvnClient", "setVcs"));
        }
        this.myVcs = vcs;
    }

    @Override
    @NotNull
    public ClientFactory getFactory() {
        ClientFactory clientFactory = this.myFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "getFactory"));
        }
        return clientFactory;
    }

    @Override
    public void setFactory(@NotNull ClientFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/BaseSvnClient", "setFactory"));
        }
        this.myFactory = factory;
    }

    protected void assertUrl(@NotNull SvnTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/BaseSvnClient", "assertUrl"));
        }
        if (!target.isURL()) {
            throw new IllegalArgumentException("Target should be url " + target);
        }
    }

    protected void assertFile(@NotNull SvnTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/BaseSvnClient", "assertFile"));
        }
        if (!target.isFile()) {
            throw new IllegalArgumentException("Target should be file " + target);
        }
    }

    protected void assertDirectory(@NotNull SvnTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/BaseSvnClient", "assertDirectory"));
        }
        this.assertFile(target);
        if (!target.getFile().isDirectory()) {
            throw new IllegalArgumentException("Target should be directory " + target);
        }
    }

    protected void validateFormat(@NotNull WorkingCopyFormat format, @NotNull Collection<WorkingCopyFormat> supported) throws VcsException {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/BaseSvnClient", "validateFormat"));
        }
        if (supported == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/api/BaseSvnClient", "validateFormat"));
        }
        if (!supported.contains((Object)format)) {
            throw new VcsException(String.format("%s format is not supported. Supported formats are: %s.", format.getName(), StringUtil.join(supported, (String)",")));
        }
    }

    protected static void callHandler(@Nullable ISVNEventHandler handler, @NotNull SVNEvent event) throws VcsException {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/api/BaseSvnClient", "callHandler"));
        }
        if (handler != null) {
            try {
                handler.handleEvent(event, 0.0);
            }
            catch (SVNException e) {
                throw new SvnBindException(e);
            }
        }
    }

    @NotNull
    protected static SVNEvent createEvent(@NotNull File path, @Nullable SVNEventAction action) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/BaseSvnClient", "createEvent"));
        }
        SVNEvent sVNEvent = new SVNEvent(path, null, null, 0L, null, null, null, null, action, null, null, null, null, null, null);
        if (sVNEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "createEvent"));
        }
        return sVNEvent;
    }
}

