/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.vcs.VcsException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitAnnotateClient
extends BaseSvnClient
implements AnnotateClient {
    @Override
    public void annotate(@NotNull SvnTarget target, @NotNull SVNRevision startRevision, @NotNull SVNRevision endRevision, @Nullable SVNRevision pegRevision, boolean includeMergedRevisions, @Nullable SVNDiffOptions diffOptions, @Nullable ISVNAnnotateHandler handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/annotate/SvnKitAnnotateClient", "annotate"));
        }
        if (startRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/annotate/SvnKitAnnotateClient", "annotate"));
        }
        if (endRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/annotate/SvnKitAnnotateClient", "annotate"));
        }
        try {
            SVNLogClient client = this.myVcs.createLogClient();
            client.setDiffOptions(diffOptions);
            if (target.isFile()) {
                client.doAnnotate(target.getFile(), pegRevision, startRevision, endRevision, true, includeMergedRevisions, handler, null);
            } else {
                client.doAnnotate(target.getURL(), pegRevision, startRevision, endRevision, true, includeMergedRevisions, handler, null);
            }
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }
}

