/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.tmatesoft.svn.core.wc.SVNRevision;

public abstract class BaseSvnFileAnnotation
extends FileAnnotation {
    protected final String myContents;
    protected final VcsRevisionNumber myBaseRevision;
    private final MyPartiallyCreatedInfos myInfos;
    protected final SvnVcs myVcs;
    private final Map<Long, SvnFileRevision> myRevisionMap = new HashMap<Long, SvnFileRevision>();
    private final LineAnnotationAspect DATE_ASPECT = new SvnAnnotationAspect(SvnAnnotationAspect.DATE, true){

        public String getValue(int lineNumber) {
            if (BaseSvnFileAnnotation.this.myInfos.size() <= lineNumber || lineNumber < 0) {
                return "";
            }
            LineInfo lineInfo = BaseSvnFileAnnotation.this.myInfos.get(lineNumber);
            return lineInfo == null ? "" : DateFormatUtil.formatPrettyDate((Date)lineInfo.getDate());
        }
    };
    private final LineAnnotationAspect REVISION_ASPECT = new SvnAnnotationAspect(SvnAnnotationAspect.REVISION, false){

        public String getValue(int lineNumber) {
            if (BaseSvnFileAnnotation.this.myInfos.size() <= lineNumber || lineNumber < 0) {
                return "";
            }
            long revision = this.getRevision(lineNumber);
            return revision == -1L ? "" : String.valueOf(revision);
        }
    };
    private final LineAnnotationAspect ORIGINAL_REVISION_ASPECT = new SvnAnnotationAspect(SvnBundle.message("annotation.original.revision", new Object[0]), false){

        public String getValue(int lineNumber) {
            long value = BaseSvnFileAnnotation.this.myInfos.originalRevision(lineNumber);
            return value == -1L ? "" : String.valueOf(value);
        }

        @Override
        protected long getRevision(int lineNum) {
            return BaseSvnFileAnnotation.this.myInfos.originalRevision(lineNum);
        }

        public String getTooltipText(int lineNumber) {
            if (BaseSvnFileAnnotation.this.myInfos.size() <= lineNumber || lineNumber < 0) {
                return "";
            }
            LineInfo info = BaseSvnFileAnnotation.this.myInfos.get(lineNumber);
            if (info == null) {
                return null;
            }
            SvnFileRevision svnRevision = (SvnFileRevision)BaseSvnFileAnnotation.this.myRevisionMap.get(info.getRevision());
            if (svnRevision != null) {
                String tooltip = "Revision " + info.getRevision() + ": " + svnRevision.getCommitMessage();
                return XmlStringUtil.escapeString((String)tooltip);
            }
            return "";
        }
    };
    private final LineAnnotationAspect AUTHOR_ASPECT = new SvnAnnotationAspect(SvnAnnotationAspect.AUTHOR, true){

        public String getValue(int lineNumber) {
            if (BaseSvnFileAnnotation.this.myInfos.size() <= lineNumber || lineNumber < 0) {
                return "";
            }
            LineInfo lineInfo = BaseSvnFileAnnotation.this.myInfos.get(lineNumber);
            return lineInfo == null ? "" : lineInfo.getAuthor();
        }
    };
    private final SvnConfiguration myConfiguration;
    private boolean myShowMergeSources;
    private SvnRevisionNumber myFirstRevisionNumber;

    public void setRevision(long revision, SvnFileRevision svnRevision) {
        this.myRevisionMap.put(revision, svnRevision);
    }

    public void clearRevisions() {
        this.myRevisionMap.clear();
    }

    public SvnFileRevision getRevision(long revision) {
        return this.myRevisionMap.get(revision);
    }

    public void setFirstRevision(SVNRevision svnRevision) {
        this.myFirstRevisionNumber = new SvnRevisionNumber(svnRevision);
    }

    public SvnRevisionNumber getFirstRevisionNumber() {
        return this.myFirstRevisionNumber;
    }

    public BaseSvnFileAnnotation(SvnVcs vcs, String contents, VcsRevisionNumber baseRevision) {
        super(vcs.getProject());
        this.myVcs = vcs;
        this.myContents = contents;
        this.myBaseRevision = baseRevision;
        this.myConfiguration = SvnConfiguration.getInstance(vcs.getProject());
        this.myShowMergeSources = this.myConfiguration.isShowMergeSourcesInAnnotate();
        this.myInfos = new MyPartiallyCreatedInfos();
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    public String getToolTip(int lineNumber) {
        if (this.myInfos.size() <= lineNumber || lineNumber < 0) {
            return "";
        }
        LineInfo info = this.myInfos.get(lineNumber);
        if (info == null) {
            return "";
        }
        SvnFileRevision svnRevision = this.myRevisionMap.get(info.getRevision());
        if (svnRevision != null) {
            if (this.myInfos.getAnnotationSource(lineNumber).showMerged()) {
                return "Merge source revision " + info.getRevision() + ": " + svnRevision.getCommitMessage();
            }
            return "Revision " + info.getRevision() + ": " + svnRevision.getCommitMessage();
        }
        return "";
    }

    public String getAnnotatedContent() {
        return this.myContents;
    }

    public void setLineInfo(int lineNumber, Date date, long revision, String author, @Nullable Date mergeDate, long mergeRevision, @Nullable String mergeAuthor) {
        this.myInfos.appendNumberedLineInfo(lineNumber, date, revision, author, mergeDate, mergeRevision, mergeAuthor);
    }

    public void appendLineInfo(Date date, long revision, String author, @Nullable Date mergeDate, long mergeRevision, @Nullable String mergeAuthor) {
        this.myInfos.appendNumberedLineInfo(date, revision, author, mergeDate, mergeRevision, mergeAuthor);
    }

    @Nullable
    public VcsRevisionNumber originalRevision(int lineNumber) {
        if (this.myInfos.size() <= lineNumber || lineNumber < 0) {
            return null;
        }
        SvnFileRevision revision = this.myRevisionMap.get(this.myInfos.originalRevision(lineNumber));
        return revision == null ? null : revision.getRevisionNumber();
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        if (this.myInfos.size() <= lineNumber || lineNumber < 0) {
            return null;
        }
        LineInfo info = this.myInfos.get(lineNumber);
        if (info == null) {
            return null;
        }
        long revision = info.getRevision();
        if (revision >= 0L) {
            return new SvnRevisionNumber(SVNRevision.create((long)revision));
        }
        return null;
    }

    public Date getLineDate(int lineNumber) {
        if (this.myInfos.size() <= lineNumber || lineNumber < 0) {
            return null;
        }
        LineInfo info = this.myInfos.get(lineNumber);
        if (info == null) {
            return null;
        }
        return info.getDate();
    }

    public List<VcsFileRevision> getRevisions() {
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>(this.myRevisionMap.values());
        Collections.sort(result, new Comparator<VcsFileRevision>(){

            @Override
            public int compare(VcsFileRevision o1, VcsFileRevision o2) {
                return -1 * o1.getRevisionNumber().compareTo((Object)o2.getRevisionNumber());
            }
        });
        return result;
    }

    public boolean revisionsNotEmpty() {
        return !this.myRevisionMap.isEmpty();
    }

    public int getNumLines() {
        return this.myInfos.size();
    }

    @Nullable
    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        if (!this.myShowMergeSources) {
            return null;
        }
        return new AnnotationSourceSwitcher(){

            @NotNull
            public AnnotationSource getAnnotationSource(int lineNumber) {
                AnnotationSource annotationSource = BaseSvnFileAnnotation.this.myInfos.getAnnotationSource(lineNumber);
                if (annotationSource == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$6", "getAnnotationSource"));
                }
                return annotationSource;
            }

            public boolean mergeSourceAvailable(int lineNumber) {
                return BaseSvnFileAnnotation.this.myInfos.mergeSourceAvailable(lineNumber);
            }

            @NotNull
            public LineAnnotationAspect getRevisionAspect() {
                LineAnnotationAspect lineAnnotationAspect = BaseSvnFileAnnotation.this.ORIGINAL_REVISION_ASPECT;
                if (lineAnnotationAspect == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$6", "getRevisionAspect"));
                }
                return lineAnnotationAspect;
            }

            @NotNull
            public AnnotationSource getDefaultSource() {
                AnnotationSource annotationSource = AnnotationSource.getInstance((boolean)BaseSvnFileAnnotation.this.myShowMergeSources);
                if (annotationSource == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$6", "getDefaultSource"));
                }
                return annotationSource;
            }

            public void switchTo(AnnotationSource source) {
                BaseSvnFileAnnotation.this.myInfos.setShowMergeSource(source.showMerged());
            }
        };
    }

    public int getLineCount() {
        return this.getNumLines();
    }

    public VcsKey getVcsKey() {
        return SvnVcs.getKey();
    }

    protected abstract void showAllAffectedPaths(SvnRevisionNumber var1);

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    private static class MyPartiallyCreatedInfos {
        private boolean myShowMergeSource;
        private final Map<Integer, LineInfo> myMappedLineInfo;
        private final Map<Integer, LineInfo> myMergeSourceInfos = new HashMap<Integer, LineInfo>();
        private int myMaxIdx = 0;

        private MyPartiallyCreatedInfos() {
            this.myMappedLineInfo = new HashMap<Integer, LineInfo>();
        }

        boolean isShowMergeSource() {
            return this.myShowMergeSource;
        }

        void setShowMergeSource(boolean showMergeSource) {
            this.myShowMergeSource = showMergeSource;
        }

        int size() {
            return this.myMaxIdx + 1;
        }

        void appendNumberedLineInfo(Date date, long revision, String author, @Nullable Date mergeDate, long mergeRevision, @Nullable String mergeAuthor) {
            this.appendNumberedLineInfo(this.myMaxIdx + 1, date, revision, author, mergeDate, mergeRevision, mergeAuthor);
        }

        void appendNumberedLineInfo(int lineNumber, Date date, long revision, String author, @Nullable Date mergeDate, long mergeRevision, @Nullable String mergeAuthor) {
            if (date == null) {
                return;
            }
            if (this.myMappedLineInfo.get(lineNumber) != null) {
                return;
            }
            this.myMaxIdx = this.myMaxIdx < lineNumber ? lineNumber : this.myMaxIdx;
            this.myMappedLineInfo.put(lineNumber, new LineInfo(date, revision, author));
            if (mergeDate != null) {
                this.myMergeSourceInfos.put(lineNumber, new LineInfo(mergeDate, mergeRevision, mergeAuthor));
            }
        }

        LineInfo get(int idx) {
            LineInfo lineInfo;
            if (this.myShowMergeSource && (lineInfo = this.myMergeSourceInfos.get(idx)) != null) {
                return lineInfo;
            }
            return this.myMappedLineInfo.get(idx);
        }

        AnnotationSource getAnnotationSource(int line) {
            return this.myShowMergeSource ? AnnotationSource.getInstance((boolean)this.myMergeSourceInfos.containsKey(line)) : AnnotationSource.LOCAL;
        }

        public long originalRevision(int line) {
            if (line >= this.size()) {
                return -1L;
            }
            LineInfo lineInfo = this.myMappedLineInfo.get(line);
            return lineInfo == null ? -1L : lineInfo.getRevision();
        }

        public boolean mergeSourceAvailable(int lineNumber) {
            return this.myMergeSourceInfos.containsKey(lineNumber);
        }
    }

    private abstract class SvnAnnotationAspect
    extends LineAnnotationAspectAdapter {
        public SvnAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        protected long getRevision(int lineNum) {
            LineInfo lineInfo = BaseSvnFileAnnotation.this.myInfos.get(lineNum);
            return lineInfo == null ? -1L : lineInfo.getRevision();
        }

        protected void showAffectedPaths(int lineNum) {
            long revision;
            if (lineNum >= 0 && lineNum < BaseSvnFileAnnotation.this.myInfos.size() && (revision = this.getRevision(lineNum)) >= 0L) {
                BaseSvnFileAnnotation.this.showAllAffectedPaths(new SvnRevisionNumber(SVNRevision.create((long)revision)));
            }
        }
    }

    static class LineInfo {
        private final Date myDate;
        private final long myRevision;
        private final String myAuthor;

        public LineInfo(Date date, long revision, String author) {
            this.myDate = date;
            this.myRevision = revision;
            this.myAuthor = author;
        }

        public Date getDate() {
            return this.myDate;
        }

        public long getRevision() {
            return this.myRevision;
        }

        public String getAuthor() {
            return this.myAuthor;
        }
    }
}

