/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.actions.VcsQuickListContentProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvnQuickListContentProvider
implements VcsQuickListContentProvider {
    public List<AnAction> getVcsActions(@Nullable Project project, @Nullable AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        if (activeVcs == null || !"svn".equals(activeVcs.getName())) {
            return null;
        }
        ActionManager manager = ActionManager.getInstance();
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        this.add("Subversion.Copy", manager, actions);
        this.add("Subversion.Clenaup", manager, actions);
        return actions;
    }

    public List<AnAction> getNotInVcsActions(@Nullable Project project, @Nullable DataContext dataContext) {
        AnAction action = ActionManager.getInstance().getAction("Subversion.ImportToSVNRepository");
        assert (action != null);
        return Collections.singletonList(action);
    }

    public boolean replaceVcsActionsFor(@NotNull AbstractVcs activeVcs, @Nullable DataContext dataContext) {
        if (activeVcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/SvnQuickListContentProvider", "replaceVcsActionsFor"));
        }
        return false;
    }

    private void add(String actionName, ActionManager manager, List<AnAction> actions) {
        AnAction action = manager.getAction(actionName);
        assert (action != null);
        actions.add(action);
    }
}

