/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.ActionExecuteHelper;
import com.intellij.vcsUtil.ActionStateConsumer;
import com.intellij.vcsUtil.ActionUpdateHelper;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.dialogs.SelectCreateExternalTargetDialog;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CreateExternalAction
extends DumbAwareAction {
    public CreateExternalAction() {
        super(SvnBundle.message("svn.create.external.below.action", new Object[0]), SvnBundle.message("svn.create.external.below.description", new Object[0]), null);
    }

    public void actionPerformed(AnActionEvent e) {
        ActionExecuteHelper helper = new ActionExecuteHelper();
        this.checkState(e, (ActionStateConsumer)helper);
        if (!helper.isOk()) {
            return;
        }
        DataContext dc = e.getDataContext();
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        final VirtualFile vf = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dc);
        SelectCreateExternalTargetDialog dialog = new SelectCreateExternalTargetDialog(project, vf);
        dialog.show();
        if (0 != dialog.getExitCode()) {
            return;
        }
        final String url = dialog.getSelectedURL();
        final boolean checkout = dialog.isCheckout();
        final String target = dialog.getLocalTarget().trim();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Creating External", true, null){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/CreateExternalAction$1", "run"));
                }
                CreateExternalAction.this.doInBackground(project, vf, url, checkout, target);
            }
        });
    }

    private void doInBackground(Project project, VirtualFile vf, String url, boolean checkout, String target) {
        SvnVcs vcs = SvnVcs.getInstance(project);
        try {
            File ioFile = new File(vf.getPath());
            if (CreateExternalAction.addToExternalProperty(vcs, ioFile, target, url)) {
                return;
            }
            final VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
            final FilePathImpl filePath = new FilePathImpl(ioFile, true);
            dirtyScopeManager.fileDirty((FilePath)filePath);
            if (checkout) {
                UpdateClient client = vcs.getFactory(ioFile).createUpdateClient();
                client.setEventHandler(new ISVNEventHandler(){

                    public void handleEvent(SVNEvent event, double progress) throws SVNException {
                    }

                    public void checkCancelled() throws SVNCancelException {
                        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
                        if (pi != null && pi.isCanceled()) {
                            throw new SVNCancelException();
                        }
                    }
                });
                client.doUpdate(ioFile, SVNRevision.HEAD, SVNDepth.UNKNOWN, false, false);
                vf.refresh(true, true, new Runnable(){

                    @Override
                    public void run() {
                        dirtyScopeManager.dirDirtyRecursively((FilePath)filePath);
                    }
                });
            }
        }
        catch (SVNException e1) {
            AbstractVcsHelper.getInstance((Project)project).showError(new VcsException((Throwable)e1), "Create External");
        }
        catch (VcsException e1) {
            AbstractVcsHelper.getInstance((Project)project).showError(e1, "Create External");
        }
    }

    public static boolean addToExternalProperty(@NotNull SvnVcs vcs, @NotNull File ioFile, String target, String url) throws SVNException, VcsException {
        String newValue;
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/CreateExternalAction", "addToExternalProperty"));
        }
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/actions/CreateExternalAction", "addToExternalProperty"));
        }
        ClientFactory factory = vcs.getFactory(ioFile);
        SVNPropertyData propertyData = factory.createPropertyClient().getProperty(SvnTarget.fromFile((File)ioFile), "svn:externals", false, SVNRevision.UNDEFINED);
        if (propertyData != null && propertyData.getValue() != null && !StringUtil.isEmptyOrSpaces((String)propertyData.getValue().getString())) {
            SVNExternal[] externals;
            for (SVNExternal external : externals = SVNExternal.parseExternals((Object)"Create External", (String)propertyData.getValue().getString())) {
                if (!Comparing.equal((String)external.getPath(), (String)target)) continue;
                AbstractVcsHelper.getInstance((Project)vcs.getProject()).showError(new VcsException("Selected destination conflicts with existing: " + external.toString()), "Create External");
                return true;
            }
            String string = CreateExternalAction.createExternalDefinitionString(url, target);
            newValue = propertyData.getValue().getString().trim() + "\n" + string;
        } else {
            newValue = CreateExternalAction.createExternalDefinitionString(url, target);
        }
        factory.createPropertyClient().setProperty(ioFile, "svn:externals", SVNPropertyValue.create((String)newValue), SVNDepth.EMPTY, false);
        return false;
    }

    public static String createExternalDefinitionString(String url, String target) {
        return CommandUtil.escape(url) + " " + target;
    }

    public void update(AnActionEvent e) {
        ActionUpdateHelper helper = new ActionUpdateHelper();
        this.checkState(e, (ActionStateConsumer)helper);
        helper.apply(e);
    }

    private void checkState(AnActionEvent e, ActionStateConsumer sc) {
        DataContext dc = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            sc.hide();
            return;
        }
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        if (!manager.checkVcsIsActive(SvnVcs.getKey().getName())) {
            sc.hide();
            return;
        }
        VirtualFile vf = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dc);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dc);
        if (vf == null || files == null || files.length != 1 || !vf.isDirectory()) {
            sc.disable();
            return;
        }
        AbstractVcs vcsFor = manager.getVcsFor(vf);
        if (vcsFor == null || !SvnVcs.getKey().equals((Object)vcsFor.getKeyInstanceMethod())) {
            sc.disable();
            return;
        }
        FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(vf);
        if (status == null || FileStatus.DELETED.equals(status) || FileStatus.IGNORED.equals(status) || FileStatus.MERGED_WITH_PROPERTY_CONFLICTS.equals(status) || FileStatus.OBSOLETE.equals(status) || FileStatus.UNKNOWN.equals(status)) {
            sc.disable();
            return;
        }
        sc.enable();
    }
}

