/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import icons.SvnIcons;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.BranchConfigurationDialog;
import org.jetbrains.idea.svn.history.SvnChangeList;

public class ConfigureBranchesAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        Presentation presentation = e.getPresentation();
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        presentation.setText(SvnBundle.message("configure.branches.item", new Object[0]));
        presentation.setDescription(SvnBundle.message("configure.branches.item", new Object[0]));
        presentation.setIcon(SvnIcons.ConfigureBranches);
        presentation.setVisible(true);
        ChangeList[] cls = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        presentation.setEnabled(cls != null && cls.length > 0 && SvnVcs.getInstance(project).getName().equals(((CommittedChangeList)cls[0]).getVcs().getName()) && ((SvnChangeList)cls[0]).getRoot() != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        ChangeList[] cls = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (cls == null || cls.length == 0 || !SvnVcs.getInstance(project).getName().equals(((CommittedChangeList)cls[0]).getVcs().getName()) || ((SvnChangeList)cls[0]).getRoot() == null) {
            return;
        }
        SvnChangeList svnList = (SvnChangeList)cls[0];
        BranchConfigurationDialog.configureBranches(project, svnList.getRoot(), true);
    }
}

