/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FileStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnFileStatus;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.portable.PortableStatus;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnStatusConvertor {
    private SvnStatusConvertor() {
    }

    @NotNull
    public static FileStatus convertStatus(@Nullable SVNStatusType itemStatus, @Nullable SVNStatusType propertiesStatus) {
        PortableStatus status = new PortableStatus();
        status.setContentsStatus(itemStatus);
        status.setPropertiesStatus(propertiesStatus);
        FileStatus fileStatus = SvnStatusConvertor.convertStatus(status);
        if (fileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
        }
        return fileStatus;
    }

    @NotNull
    public static FileStatus convertStatus(@Nullable SVNStatus status) {
        if (status == null) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (SvnVcs.svnStatusIsUnversioned(status)) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_MISSING)) {
            FileStatus fileStatus = FileStatus.DELETED_FROM_FS;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_EXTERNAL)) {
            FileStatus fileStatus = SvnFileStatus.EXTERNAL;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_OBSTRUCTED)) {
            FileStatus fileStatus = SvnFileStatus.OBSTRUCTED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_IGNORED)) {
            FileStatus fileStatus = FileStatus.IGNORED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_ADDED)) {
            FileStatus fileStatus = FileStatus.ADDED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_DELETED)) {
            FileStatus fileStatus = FileStatus.DELETED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_REPLACED)) {
            FileStatus fileStatus = SvnFileStatus.REPLACED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_CONFLICTED || status.getPropertiesStatus() == SVNStatusType.STATUS_CONFLICTED) {
            if (status.getContentsStatus() == SVNStatusType.STATUS_CONFLICTED && status.getPropertiesStatus() == SVNStatusType.STATUS_CONFLICTED) {
                FileStatus fileStatus = FileStatus.MERGED_WITH_BOTH_CONFLICTS;
                if (fileStatus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
                }
                return fileStatus;
            }
            if (status.getContentsStatus() == SVNStatusType.STATUS_CONFLICTED) {
                FileStatus fileStatus = FileStatus.MERGED_WITH_CONFLICTS;
                if (fileStatus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
                }
                return fileStatus;
            }
            FileStatus fileStatus = FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_MODIFIED || status.getPropertiesStatus() == SVNStatusType.STATUS_MODIFIED) {
            FileStatus fileStatus = FileStatus.MODIFIED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.isSwitched()) {
            FileStatus fileStatus = FileStatus.SWITCHED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        if (status.isCopied()) {
            FileStatus fileStatus = FileStatus.ADDED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
            }
            return fileStatus;
        }
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        if (fileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertStatus"));
        }
        return fileStatus;
    }

    @NotNull
    public static FileStatus convertPropertyStatus(SVNStatusType status) {
        if (status == null) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (SVNStatusType.STATUS_UNVERSIONED.equals(status)) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (SVNStatusType.STATUS_MISSING.equals(status)) {
            FileStatus fileStatus = FileStatus.DELETED_FROM_FS;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (SVNStatusType.STATUS_EXTERNAL.equals(status)) {
            FileStatus fileStatus = SvnFileStatus.EXTERNAL;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (SVNStatusType.STATUS_OBSTRUCTED.equals(status)) {
            FileStatus fileStatus = SvnFileStatus.OBSTRUCTED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (SVNStatusType.STATUS_IGNORED.equals(status)) {
            FileStatus fileStatus = FileStatus.IGNORED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (SVNStatusType.STATUS_ADDED.equals(status)) {
            FileStatus fileStatus = FileStatus.ADDED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (SVNStatusType.STATUS_DELETED.equals(status)) {
            FileStatus fileStatus = FileStatus.DELETED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (SVNStatusType.STATUS_REPLACED.equals(status)) {
            FileStatus fileStatus = SvnFileStatus.REPLACED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (status == SVNStatusType.STATUS_CONFLICTED) {
            FileStatus fileStatus = FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        if (status == SVNStatusType.STATUS_MODIFIED) {
            FileStatus fileStatus = FileStatus.MODIFIED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
            }
            return fileStatus;
        }
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        if (fileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnStatusConvertor", "convertPropertyStatus"));
        }
        return fileStatus;
    }
}

