/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.StatusWalkerPartner;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.commandLine.SvnCommandLineStatusClient;
import org.jetbrains.idea.svn.portable.SvnStatusClientI;
import org.jetbrains.idea.svn.portable.SvnkitSvnStatusClient;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnRecursiveStatusWalker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnRecursiveStatusWalker");
    private final StatusWalkerPartner myPartner;
    private final SvnVcs myVcs;
    private final Project myProject;
    private final StatusReceiver myReceiver;
    private final LinkedList<MyItem> myQueue;
    private final MyHandler myHandler;

    public SvnRecursiveStatusWalker(SvnVcs vcs, StatusReceiver receiver, StatusWalkerPartner partner) {
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myReceiver = receiver;
        this.myPartner = partner;
        this.myQueue = new LinkedList();
        this.myHandler = new MyHandler();
    }

    public void go(FilePath rootPath, SVNDepth depth) throws SVNException {
        MyItem root = new MyItem(this.myVcs, rootPath, depth, this.myPartner.createStatusClient(), false);
        this.myQueue.add(root);
        while (!this.myQueue.isEmpty()) {
            this.myPartner.checkCanceled();
            MyItem item = this.myQueue.removeFirst();
            FilePath path = item.getPath();
            File ioFile = path.getIOFile();
            if (path.isDirectory()) {
                this.myHandler.setCurrentItem(item);
                try {
                    SvnStatusClientI client = item.getClient(ioFile);
                    client.doStatus(ioFile, SVNRevision.WORKING, item.getDepth(), false, false, true, true, this.myHandler, null);
                    this.myHandler.checkIfCopyRootWasReported(null, ioFile);
                }
                catch (SVNException e) {
                    this.handleStatusException(item, path, e);
                }
                continue;
            }
            try {
                SVNStatus status = item.getClient(ioFile).doStatus(ioFile, false, false);
                this.myReceiver.process(path, status);
            }
            catch (SVNException e) {
                this.handleStatusException(item, path, e);
            }
        }
    }

    private void handleStatusException(MyItem item, FilePath path, SVNException e) throws SVNException {
        SVNErrorCode errorCode = e.getErrorMessage().getErrorCode();
        if (SVNErrorCode.WC_NOT_DIRECTORY.equals((Object)errorCode) || SVNErrorCode.WC_NOT_FILE.equals((Object)errorCode)) {
            VirtualFile virtualFile = path.getVirtualFile();
            if (virtualFile != null && !this.myPartner.isExcluded(virtualFile)) {
                this.myReceiver.processUnversioned(virtualFile);
                if (virtualFile.isDirectory()) {
                    this.processRecursively(virtualFile, item.getDepth());
                }
            }
        } else {
            throw e;
        }
    }

    private void processRecursively(VirtualFile vFile, SVNDepth prevDepth) {
        Object processor;
        Processor directoryFilter;
        if (SVNDepth.EMPTY.equals((Object)prevDepth)) {
            return;
        }
        if (this.myPartner.isIgnoredIdeaLevel(vFile)) {
            this.myReceiver.processIgnored(vFile);
            return;
        }
        final SVNDepth newDepth = SVNDepth.INFINITY.equals((Object)prevDepth) ? SVNDepth.INFINITY : SVNDepth.EMPTY;
        final File ioFile = new File(vFile.getPath());
        final Ref lastIgnored = new Ref();
        Processor<File> checkDirProcessor = new Processor<File>(){

            public boolean process(File file) {
                FilePathImpl path = new FilePathImpl(file, true);
                path.refresh();
                path.hardRefresh();
                VirtualFile vf = path.getVirtualFile();
                if (vf != null && SvnRecursiveStatusWalker.this.myPartner.isIgnoredIdeaLevel(vf)) {
                    lastIgnored.set((Object)file);
                    SvnRecursiveStatusWalker.this.myReceiver.processIgnored(vf);
                    return true;
                }
                if (file.isDirectory() && new File(file, SVNFileUtil.getAdminDirectoryName()).exists()) {
                    MyItem childItem = new MyItem(SvnRecursiveStatusWalker.this.myVcs, (FilePath)path, newDepth, SvnRecursiveStatusWalker.this.myPartner.createStatusClient(), true);
                    SvnRecursiveStatusWalker.this.myQueue.add(childItem);
                } else if (vf != null) {
                    SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vf);
                }
                return true;
            }
        };
        if (SVNDepth.EMPTY.equals((Object)newDepth)) {
            directoryFilter = Processor.TRUE;
            processor = new Processor<File>((Processor)checkDirProcessor){
                final /* synthetic */ Processor val$checkDirProcessor;
                {
                    this.val$checkDirProcessor = processor;
                }

                public boolean process(File file) {
                    if (!FileUtil.filesEqual((File)ioFile, (File)file)) {
                        return true;
                    }
                    if (!FileUtil.filesEqual((File)ioFile, (File)file.getParentFile())) {
                        return false;
                    }
                    return this.val$checkDirProcessor.process((Object)file);
                }
            };
        } else {
            directoryFilter = new Processor<File>(){

                public boolean process(File file) {
                    return !Comparing.equal((Object)lastIgnored, (Object)file) && (SvnRecursiveStatusWalker.this.myQueue.isEmpty() || !FileUtil.filesEqual((File)((MyItem)SvnRecursiveStatusWalker.this.myQueue.getLast()).getPath().getIOFile(), (File)file));
                }
            };
            processor = checkDirProcessor;
        }
        FileUtil.processFilesRecursively((File)ioFile, (Processor)processor, (Processor)directoryFilter);
    }

    private VirtualFile getVirtualFile(File ioFile) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile vFile = lfs.findFileByIoFile(ioFile);
        if (vFile == null) {
            vFile = lfs.refreshAndFindFileByIoFile(ioFile);
        }
        return vFile;
    }

    private class MyHandler
    implements ISVNStatusHandler {
        private MyItem myCurrentItem;
        private boolean myMetCurrentItem;

        private MyHandler() {
        }

        public void setCurrentItem(MyItem currentItem) {
            this.myCurrentItem = currentItem;
            this.myMetCurrentItem = false;
        }

        public void checkIfCopyRootWasReported(@Nullable SVNStatus ioFileStatus, File ioFile) {
            File itemFile = this.myCurrentItem.getPath().getIOFile();
            if (!this.myMetCurrentItem && FileUtil.filesEqual((File)ioFile, (File)itemFile)) {
                SVNStatus statusInner;
                this.myMetCurrentItem = true;
                try {
                    statusInner = ioFileStatus != null ? ioFileStatus : this.myCurrentItem.getClient(itemFile).doStatus(itemFile, false);
                }
                catch (SVNException e) {
                    LOG.info((Throwable)e);
                    statusInner = null;
                }
                if (statusInner == null) {
                    return;
                }
                SVNStatusType status = statusInner.getNodeStatus();
                VirtualFile vf = this.myCurrentItem.getPath().getVirtualFile();
                if (SVNStatusType.STATUS_IGNORED.equals(status)) {
                    if (vf != null) {
                        SvnRecursiveStatusWalker.this.myReceiver.processIgnored(vf);
                    }
                    return;
                }
                if (SVNStatusType.STATUS_UNVERSIONED.equals(status) || SVNStatusType.UNKNOWN.equals(status)) {
                    if (vf != null) {
                        SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vf);
                        SvnRecursiveStatusWalker.this.processRecursively(vf, this.myCurrentItem.getDepth());
                    }
                    return;
                }
                if (SVNStatusType.OBSTRUCTED.equals(status) || SVNStatusType.STATUS_NONE.equals(status)) {
                    return;
                }
                if (vf != null) {
                    if (this.myCurrentItem.isIsInnerCopyRoot()) {
                        SvnRecursiveStatusWalker.this.myReceiver.processCopyRoot(vf, statusInner.getURL(), SvnRecursiveStatusWalker.this.myVcs.getWorkingCopyFormat(ioFile), statusInner.getRepositoryRootURL());
                    } else {
                        SvnRecursiveStatusWalker.this.myReceiver.bewareRoot(vf, statusInner.getURL());
                    }
                }
            }
        }

        public void handleStatus(SVNStatus status) throws SVNException {
            Boolean excluded;
            SvnRecursiveStatusWalker.this.myPartner.checkCanceled();
            File ioFile = status.getFile();
            this.checkIfCopyRootWasReported(status, ioFile);
            final VirtualFile vFile = SvnRecursiveStatusWalker.this.getVirtualFile(ioFile);
            if (vFile != null && Boolean.TRUE.equals(excluded = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    if (SvnRecursiveStatusWalker.this.myProject.isDisposed()) {
                        return null;
                    }
                    return SvnRecursiveStatusWalker.this.myPartner.isExcluded(vFile);
                }
            }))) {
                return;
            }
            if (SvnRecursiveStatusWalker.this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (vFile != null && SvnVcs.svnStatusIsUnversioned(status)) {
                if (vFile.isDirectory()) {
                    if (!FileUtil.filesEqual((File)this.myCurrentItem.getPath().getIOFile(), (File)ioFile)) {
                        MyItem childItem = new MyItem(SvnRecursiveStatusWalker.this.myVcs, (FilePath)new FilePathImpl(vFile), SVNDepth.INFINITY, SvnRecursiveStatusWalker.this.myPartner.createStatusClient(), true);
                        SvnRecursiveStatusWalker.this.myQueue.add(childItem);
                    }
                } else {
                    SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vFile);
                }
            } else {
                FilePath path = VcsUtil.getFilePath((File)ioFile, (boolean)status.getKind().equals(SVNNodeKind.DIR));
                SvnRecursiveStatusWalker.this.myReceiver.process(path, status);
            }
        }
    }

    private static class MyItem {
        private final Project myProject;
        private final FilePath myPath;
        private final SVNDepth myDepth;
        private final SvnStatusClientI mySvnClient;
        private final SvnStatusClientI myCommandLineClient;
        private final boolean myIsInnerCopyRoot;
        private final SvnConfiguration myConfiguration17;
        private final SvnVcs myVcs;

        private MyItem(SvnVcs vcs, FilePath path, SVNDepth depth, SVNStatusClient client, boolean isInnerCopyRoot) {
            this.myVcs = vcs;
            this.myProject = vcs.getProject();
            this.myConfiguration17 = SvnConfiguration.getInstance(this.myProject);
            this.myPath = path;
            this.myDepth = depth;
            this.mySvnClient = new SvnkitSvnStatusClient(this.myVcs, client);
            this.myCommandLineClient = new SvnCommandLineStatusClient(this.myVcs);
            this.myIsInnerCopyRoot = isInnerCopyRoot;
        }

        public FilePath getPath() {
            return this.myPath;
        }

        public SVNDepth getDepth() {
            return this.myDepth;
        }

        public SvnStatusClientI getClient(File file) {
            WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(file);
            if (format == WorkingCopyFormat.ONE_DOT_EIGHT) {
                return this.myCommandLineClient;
            }
            if (format == WorkingCopyFormat.ONE_DOT_SIX) {
                return this.mySvnClient;
            }
            return this.myConfiguration17.isCommandLine() ? this.myCommandLineClient : this.mySvnClient;
        }

        public boolean isIsInnerCopyRoot() {
            return this.myIsInnerCopyRoot;
        }
    }
}

