/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffMixin;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.DiffProviderEx;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.history.LatestExistentSearcher;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnDiffProvider
extends DiffProviderEx
implements DiffProvider,
DiffMixin {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnDiffProvider");
    public static final String COMMIT_MESSAGE = "svn:log";
    private static final int BATCH_INFO_SIZE = 20;
    private final SvnVcs myVcs;

    public SvnDiffProvider(SvnVcs vcs) {
        this.myVcs = vcs;
    }

    public VcsRevisionNumber getCurrentRevision(VirtualFile file) {
        SVNInfo svnInfo = this.myVcs.getInfo(new File(file.getPresentableUrl()));
        return SvnDiffProvider.getRevision(svnInfo);
    }

    @Nullable
    private static VcsRevisionNumber getRevision(@Nullable SVNInfo info) {
        SvnRevisionNumber result = null;
        if (info != null) {
            SVNRevision revision = SVNRevision.UNDEFINED.equals((Object)info.getCommittedRevision()) && info.getCopyFromRevision() != null ? info.getCopyFromRevision() : info.getRevision();
            result = new SvnRevisionNumber(revision);
        }
        return result;
    }

    public Map<VirtualFile, VcsRevisionNumber> getCurrentRevisions(Iterable<VirtualFile> files) {
        HashMap result = ContainerUtil.newHashMap();
        HashMap items = ContainerUtil.newHashMap();
        ArrayList ioFiles = ContainerUtil.newArrayList();
        for (VirtualFile file : files) {
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            ioFiles.add(ioFile);
            items.put(ioFile.getAbsolutePath(), file);
            if (items.size() != 20) continue;
            this.collectRevisionsInBatch(result, items, ioFiles);
            items.clear();
            ioFiles.clear();
        }
        this.collectRevisionsInBatch(result, items, ioFiles);
        return result;
    }

    private void collectRevisionsInBatch(@NotNull Map<VirtualFile, VcsRevisionNumber> revisionMap, @NotNull Map<String, VirtualFile> fileMap, @NotNull List<File> ioFiles) {
        if (revisionMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnDiffProvider", "collectRevisionsInBatch"));
        }
        if (fileMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnDiffProvider", "collectRevisionsInBatch"));
        }
        if (ioFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/SvnDiffProvider", "collectRevisionsInBatch"));
        }
        this.myVcs.collectInfo(ioFiles, SvnDiffProvider.createInfoHandler(revisionMap, fileMap));
    }

    @NotNull
    private static ISVNInfoHandler createInfoHandler(final @NotNull Map<VirtualFile, VcsRevisionNumber> revisionMap, final @NotNull Map<String, VirtualFile> fileMap) {
        if (revisionMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnDiffProvider", "createInfoHandler"));
        }
        if (fileMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnDiffProvider", "createInfoHandler"));
        }
        ISVNInfoHandler iSVNInfoHandler = new ISVNInfoHandler(){

            public void handleInfo(SVNInfo info) throws SVNException {
                if (info != null) {
                    VirtualFile file = (VirtualFile)fileMap.get(info.getFile().getAbsolutePath());
                    if (file != null) {
                        revisionMap.put(file, SvnDiffProvider.getRevision(info));
                    } else {
                        LOG.info("Could not find virtual file for path " + info.getFile().getAbsolutePath());
                    }
                }
            }
        };
        if (iSVNInfoHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "createInfoHandler"));
        }
        return iSVNInfoHandler;
    }

    public VcsRevisionDescription getCurrentRevisionDescription(VirtualFile file) {
        File path = new File(file.getPresentableUrl());
        return this.getCurrentRevisionDescription(path);
    }

    private VcsRevisionDescription getCurrentRevisionDescription(File path) {
        SVNInfo svnInfo = this.myVcs.getInfo(path);
        if (svnInfo == null) {
            return null;
        }
        if (svnInfo.getCommittedRevision().equals((Object)SVNRevision.UNDEFINED) && !svnInfo.getCopyFromRevision().equals((Object)SVNRevision.UNDEFINED) && svnInfo.getCopyFromURL() != null) {
            SVNURL copyUrl = svnInfo.getCopyFromURL();
            String localPath = this.myVcs.getSvnFileUrlMapping().getLocalPath(copyUrl.toString());
            if (localPath != null) {
                return this.getCurrentRevisionDescription(new File(localPath));
            }
        }
        try {
            String message = this.getCommitMessage(path);
            return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new SvnRevisionNumber(svnInfo.getCommittedRevision()), svnInfo.getCommittedDate(), svnInfo.getAuthor(), message);
        }
        catch (VcsException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    private String getCommitMessage(File path) throws VcsException {
        SVNPropertyData property = this.myVcs.getFactory(path).createPropertyClient().getProperty(SvnTarget.fromFile((File)path), COMMIT_MESSAGE, true, SVNRevision.BASE);
        return property != null ? SVNPropertyValue.getPropertyAsString((SVNPropertyValue)property.getValue()) : null;
    }

    private static ItemLatestState defaultResult() {
        return SvnDiffProvider.createResult(SVNRevision.HEAD, true, true);
    }

    private static ItemLatestState createResult(SVNRevision revision, boolean exists, boolean defaultHead) {
        return new ItemLatestState((VcsRevisionNumber)new SvnRevisionNumber(revision), exists, defaultHead);
    }

    public ItemLatestState getLastRevision(VirtualFile file) {
        return this.getLastRevision(new File(file.getPath()));
    }

    public ContentRevision createFileContent(VcsRevisionNumber revisionNumber, VirtualFile selectedFile) {
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(selectedFile);
        SVNRevision svnRevision = ((SvnRevisionNumber)revisionNumber).getRevision();
        if (!SVNRevision.HEAD.equals((Object)svnRevision) && revisionNumber.equals(this.getCurrentRevision(selectedFile))) {
            return SvnContentRevision.createBaseRevision(this.myVcs, filePath, svnRevision);
        }
        SVNStatus svnStatus = this.getFileStatus(new File(selectedFile.getPresentableUrl()), false);
        if (svnStatus != null && svnRevision.equals((Object)svnStatus.getRevision())) {
            return SvnContentRevision.createBaseRevision(this.myVcs, filePath, svnRevision);
        }
        return SvnContentRevision.createRemote(this.myVcs, filePath, svnRevision);
    }

    private SVNStatus getFileStatus(File file, boolean remote) {
        SVNStatus result = null;
        try {
            result = this.myVcs.getFactory(file).createStatusClient().doStatus(file, remote, false);
        }
        catch (SVNException e) {
            LOG.debug((Throwable)e);
        }
        return result;
    }

    public ItemLatestState getLastRevision(FilePath filePath) {
        return this.getLastRevision(filePath.getIOFile());
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return null;
    }

    private ItemLatestState getLastRevision(File file) {
        SVNStatus svnStatus = this.getFileStatus(file, true);
        if (svnStatus == null || this.itemExists(svnStatus) && SVNRevision.UNDEFINED.equals((Object)svnStatus.getRemoteRevision())) {
            SVNInfo info = this.myVcs.getInfo(file, SVNRevision.HEAD);
            if (info == null || info.getURL() == null) {
                LOG.info("No SVN status returned for " + file.getPath());
                return SvnDiffProvider.defaultResult();
            }
            return SvnDiffProvider.createResult(info.getCommittedRevision(), true, false);
        }
        boolean exists = this.itemExists(svnStatus);
        if (!exists) {
            WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(file);
            long revision = -1L;
            if (!WorkingCopyFormat.ONE_DOT_EIGHT.equals((Object)format)) {
                LatestExistentSearcher searcher = new LatestExistentSearcher(this.myVcs, svnStatus.getURL());
                revision = searcher.getDeletionRevision();
            }
            return SvnDiffProvider.createResult(SVNRevision.create((long)revision), exists, false);
        }
        SVNRevision remoteRevision = svnStatus.getRemoteRevision();
        if (remoteRevision != null) {
            return SvnDiffProvider.createResult(remoteRevision, exists, false);
        }
        return SvnDiffProvider.createResult(svnStatus.getRevision(), exists, false);
    }

    private boolean itemExists(SVNStatus svnStatus) {
        return !SVNStatusType.STATUS_DELETED.equals(svnStatus.getRemoteContentsStatus()) && !SVNStatusType.STATUS_DELETED.equals(svnStatus.getRemoteNodeStatus());
    }
}

