/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.UriUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNURL;

public class RootUrlInfo
implements RootUrlPair {
    @NotNull
    private final String myRepositoryUrl;
    @NotNull
    private final WorkingCopyFormat myFormat;
    @NotNull
    private final Node myNode;
    @NotNull
    private final VirtualFile myRoot;
    @Nullable
    private volatile NestedCopyType myType;

    public RootUrlInfo(@NotNull Node node, @NotNull WorkingCopyFormat format, @NotNull VirtualFile root) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/RootUrlInfo", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/RootUrlInfo", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/RootUrlInfo", "<init>"));
        }
        this(node, format, root, null);
    }

    public RootUrlInfo(@NotNull Node node, @NotNull WorkingCopyFormat format, @NotNull VirtualFile root, @Nullable NestedCopyType type) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/RootUrlInfo", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/RootUrlInfo", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/RootUrlInfo", "<init>"));
        }
        this.myNode = node;
        this.myFormat = format;
        this.myRoot = root;
        this.myRepositoryUrl = UriUtil.trimTrailingSlashes((String)node.getRepositoryRootUrl().toString());
        this.myType = type;
    }

    @NotNull
    public Node getNode() {
        Node node = this.myNode;
        if (node == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/RootUrlInfo", "getNode"));
        }
        return node;
    }

    @NotNull
    public String getRepositoryUrl() {
        String string = this.myRepositoryUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/RootUrlInfo", "getRepositoryUrl"));
        }
        return string;
    }

    @NotNull
    public SVNURL getRepositoryUrlUrl() {
        SVNURL sVNURL = this.myNode.getRepositoryRootUrl();
        if (sVNURL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/RootUrlInfo", "getRepositoryUrlUrl"));
        }
        return sVNURL;
    }

    @NotNull
    public String getAbsoluteUrl() {
        String string = this.getAbsoluteUrlAsUrl().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/RootUrlInfo", "getAbsoluteUrl"));
        }
        return string;
    }

    @NotNull
    public SVNURL getAbsoluteUrlAsUrl() {
        SVNURL sVNURL = this.myNode.getUrl();
        if (sVNURL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/RootUrlInfo", "getAbsoluteUrlAsUrl"));
        }
        return sVNURL;
    }

    @NotNull
    public WorkingCopyFormat getFormat() {
        WorkingCopyFormat workingCopyFormat = this.myFormat;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/RootUrlInfo", "getFormat"));
        }
        return workingCopyFormat;
    }

    @NotNull
    public File getIoFile() {
        File file = this.myNode.getIoFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/RootUrlInfo", "getIoFile"));
        }
        return file;
    }

    @NotNull
    public String getPath() {
        String string = this.getIoFile().getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/RootUrlInfo", "getPath"));
        }
        return string;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/RootUrlInfo", "getRoot"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myNode.getFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/RootUrlInfo", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.getAbsoluteUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/RootUrlInfo", "getUrl"));
        }
        return string;
    }

    @Nullable
    public NestedCopyType getType() {
        return this.myType;
    }

    public void setType(@Nullable NestedCopyType type) {
        this.myType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootUrlInfo info = (RootUrlInfo)o;
        if (this.myFormat != info.myFormat) {
            return false;
        }
        if (!this.myNode.equals(info.myNode)) {
            return false;
        }
        if (!this.myRoot.equals(info.myRoot)) {
            return false;
        }
        return this.myType == info.myType;
    }

    public int hashCode() {
        int result = this.myFormat.hashCode();
        result = 31 * result + this.myNode.hashCode();
        result = 31 * result + this.myRoot.hashCode();
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        return result;
    }
}

