/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNException;

public abstract class RepeatSvnActionThroughBusy {
    public static final int REPEAT = 10;
    protected int myCnt = 10;
    protected long myTimeout = 50L;
    protected Object myT;

    protected abstract void executeImpl() throws SVNException;

    public <T> T compute() throws SVNException {
        this.execute();
        return (T)this.myT;
    }

    public void execute() throws SVNException {
        while (true) {
            try {
                this.executeImpl();
            }
            catch (SVNException e) {
                if (SvnVcs.ourBusyExceptionProcessor.process((Object)e) && this.myCnt > 0) {
                    try {
                        Thread.sleep(this.myTimeout * (long)(10 - this.myCnt + 1));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    --this.myCnt;
                    continue;
                }
                throw e;
            }
            break;
        }
    }
}

