/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class ForNestedRootChecker {
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final VcsRootIterator myRootIterator;

    public ForNestedRootChecker(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/ForNestedRootChecker", "<init>"));
        }
        this.myVcs = vcs;
        this.myRootIterator = new VcsRootIterator(vcs.getProject(), (AbstractVcs)vcs);
    }

    public List<Node> getAllNestedWorkingCopies(@NotNull VirtualFile root, boolean goIntoNested) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/ForNestedRootChecker", "getAllNestedWorkingCopies"));
        }
        LinkedList<WorkItem> workItems = new LinkedList<WorkItem>();
        LinkedList<Node> result = new LinkedList<Node>();
        workItems.add(new WorkItem(root));
        while (!workItems.isEmpty()) {
            VirtualFile file;
            WorkItem item = (WorkItem)workItems.removeFirst();
            this.checkCancelled();
            Node vcsElement = new VcsFileResolver(this.myVcs, item.file).resolve();
            if (vcsElement != null && (item.url == null || vcsElement.onUrl(item.url))) {
                result.add(vcsElement);
                if (!goIntoNested) continue;
            }
            if (!(file = item.file).isDirectory() || SvnUtil.isAdminDirectory(file)) continue;
            for (VirtualFile child : file.getChildren()) {
                this.checkCancelled();
                if (!this.myRootIterator.acceptFolderUnderVcs(root, child)) continue;
                workItems.add(WorkItem.create(vcsElement, child));
            }
        }
        return result;
    }

    private void checkCancelled() {
        if (this.myVcs.getProject().isDisposed()) {
            throw new ProcessCanceledException();
        }
    }

    private static class VcsFileResolver {
        @NotNull
        private final SvnVcs myVcs;
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final File myIoFile;
        @Nullable
        private SVNInfo myInfo;
        @Nullable
        private SVNException myError;

        private VcsFileResolver(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/ForNestedRootChecker$VcsFileResolver", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/ForNestedRootChecker$VcsFileResolver", "<init>"));
            }
            this.myVcs = vcs;
            this.myFile = file;
            this.myIoFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        }

        @Nullable
        public Node resolve() {
            this.runInfo();
            return this.processInfo();
        }

        private void runInfo() {
            try {
                this.myInfo = this.myVcs.getFactory(this.myIoFile, false).createInfoClient().doInfo(this.myIoFile, SVNRevision.UNDEFINED);
            }
            catch (SVNException e) {
                this.myError = e;
            }
        }

        @Nullable
        private Node processInfo() {
            Node result = null;
            if (this.myError != null) {
                SVNErrorCode errorCode = this.myError.getErrorMessage().getErrorCode();
                if (!SvnUtil.isUnversionedOrNotFound(errorCode)) {
                    result = new Node(this.myFile, this.getFakeUrl(), this.getFakeUrl(), this.myError);
                }
            } else if (this.myInfo != null && this.myInfo.getRepositoryRootURL() != null && this.myInfo.getURL() != null) {
                result = new Node(this.myFile, this.myInfo.getURL(), this.myInfo.getRepositoryRootURL());
            }
            return result;
        }

        private SVNURL getFakeUrl() {
            try {
                return SVNURL.fromFile((File)this.myIoFile);
            }
            catch (SVNException e) {
                throw SvnUtil.createIllegalArgument(e);
            }
        }
    }

    private static class WorkItem {
        @NotNull
        private final VirtualFile file;
        @Nullable
        private final SVNURL url;

        private WorkItem(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/ForNestedRootChecker$WorkItem", "<init>"));
            }
            this(file, (SVNURL)null);
        }

        private WorkItem(@NotNull VirtualFile file, @Nullable SVNURL url) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/ForNestedRootChecker$WorkItem", "<init>"));
            }
            this.file = file;
            this.url = url;
        }

        @NotNull
        private static WorkItem create(@Nullable Node node, @NotNull VirtualFile child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/ForNestedRootChecker$WorkItem", "create"));
            }
            WorkItem workItem = node == null ? new WorkItem(child) : new WorkItem(child, SvnUtil.append(node.getUrl(), child.getName()));
            if (workItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/ForNestedRootChecker$WorkItem", "create"));
            }
            return workItem;
        }
    }
}

