/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import gnu.trove.THashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkipDefaultValuesSerializationFilters
implements SerializationFilter {
    private final Map<Class<?>, Object> myDefaultBeans = new THashMap();

    @Override
    public boolean accepts(Accessor accessor, @Nullable Object bean) {
        if (bean == null) {
            return true;
        }
        Object defaultBean = this.getDefaultBean(bean);
        Object defValue = accessor.read(defaultBean);
        Object beanValue = accessor.read(bean);
        if (defValue instanceof Element && beanValue instanceof Element) {
            return !JDOMUtil.areElementsEqual((Element)beanValue, (Element)defValue);
        }
        return !Comparing.equal(beanValue, defValue);
    }

    private Object getDefaultBean(@NotNull Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "getDefaultBean"));
        }
        Class<?> c = bean.getClass();
        Object o = this.myDefaultBeans.get(c);
        if (o == null) {
            o = XmlSerializerImpl.newInstance(c);
            this.configure(o);
            this.myDefaultBeans.put(c, o);
        }
        return o;
    }

    protected void configure(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "configure"));
        }
    }
}

