/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.OptionTag;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OptionTagBinding
extends BasePrimitiveBinding {
    private static final Logger LOG = Logger.getInstance(OptionTagBinding.class);
    private final String myTagName;
    private final String myNameAttribute;
    private final String myValueAttribute;

    public OptionTagBinding(@NotNull Accessor accessor, @Nullable OptionTag optionTag) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xmlb/OptionTagBinding", "<init>"));
        }
        super(accessor, optionTag == null ? null : optionTag.value(), optionTag == null ? null : optionTag.converter());
        if (optionTag != null) {
            this.myTagName = optionTag.tag();
            this.myNameAttribute = optionTag.nameAttribute();
            this.myValueAttribute = optionTag.valueAttribute();
        } else {
            this.myTagName = "option";
            this.myNameAttribute = "name";
            this.myValueAttribute = "value";
        }
    }

    @Override
    public Object serialize(Object o, Object context, SerializationFilter filter) {
        Element targetElement = new Element(this.myTagName);
        Object value = this.myAccessor.read(o);
        if (!StringUtil.isEmpty(this.myNameAttribute)) {
            targetElement.setAttribute(this.myNameAttribute, this.myName);
        }
        if (value == null) {
            return targetElement;
        }
        if (this.myConverter != null) {
            targetElement.setAttribute(this.myValueAttribute, this.myConverter.toString(value));
        } else {
            assert (this.myBinding != null);
            Object node = this.myBinding.serialize(value, targetElement, filter);
            if (node instanceof Text) {
                Text text = (Text)node;
                targetElement.setAttribute(this.myValueAttribute, text.getText());
            } else if (targetElement != node) {
                JDOMUtil.addContent(targetElement, node);
            }
        }
        return targetElement;
    }

    @Override
    public Object deserialize(Object context, Object ... nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xmlb/OptionTagBinding", "deserialize"));
        }
        if (nodes.length > 1) {
            LOG.info("Duplicate options for " + context + " will be ignored");
        }
        assert (nodes.length != 0) : "Empty nodes passed to: " + this;
        Element element = (Element)nodes[0];
        Attribute valueAttribute = element.getAttribute(this.myValueAttribute);
        if (valueAttribute != null) {
            Object value;
            if (this.myConverter != null) {
                value = this.myConverter.fromString(valueAttribute.getValue());
            } else {
                assert (this.myBinding != null);
                value = this.myBinding.deserialize(context, valueAttribute);
            }
            this.myAccessor.write(context, value);
        } else {
            SmartList<Content> children = new SmartList<Content>();
            for (Content child : element.getContent()) {
                if (XmlSerializerImpl.isIgnoredNode(child)) continue;
                children.add(child);
            }
            if (!children.isEmpty()) {
                assert (this.myBinding != null);
                Object value = this.myBinding.deserialize(this.myAccessor.read(context), ArrayUtil.toObjectArray(children));
                this.myAccessor.write(context, value);
            } else {
                this.myAccessor.write(context, null);
            }
        }
        return context;
    }

    @Override
    public boolean isBoundTo(Object node) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element e = (Element)node;
        if (!e.getName().equals(this.myTagName)) {
            return false;
        }
        String name = e.getAttributeValue(this.myNameAttribute);
        if (StringUtil.isEmpty(this.myNameAttribute)) {
            return name == null || name.equals(this.myName);
        }
        return name != null && name.equals(this.myName);
    }

    @Override
    public Class getBoundNodeType() {
        throw new UnsupportedOperationException("Method getBoundNodeType is not supported in " + this.getClass());
    }

    @NonNls
    public String toString() {
        return "OptionTagBinding[" + this.myName + ", binding=" + this.myBinding + "]";
    }
}

