/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.annotations.Nullable;

class AccessorBindingWrapper
implements Binding {
    private final Accessor myAccessor;
    private final Binding myBinding;

    public AccessorBindingWrapper(Accessor accessor, Binding binding) {
        this.myAccessor = accessor;
        this.myBinding = binding;
    }

    @Override
    public Object serialize(Object o, Object context, SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        if (value == null) {
            throw new XmlSerializationException("Property " + this.myAccessor + " of object " + o + " (" + o.getClass() + ") must not be null");
        }
        return this.myBinding.serialize(value, context, filter);
    }

    @Override
    @Nullable
    public Object deserialize(Object context, Object ... nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xmlb/AccessorBindingWrapper", "deserialize"));
        }
        this.myAccessor.write(context, this.myBinding.deserialize(this.myAccessor.read(context), nodes));
        return context;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return this.myBinding.isBoundTo(node);
    }

    @Override
    public Class getBoundNodeType() {
        return this.myBinding.getBoundNodeType();
    }

    @Override
    public void init() {
    }
}

