/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Pair;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Centerizer
extends JPanel {
    public Centerizer(@NotNull JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/Centerizer", "<init>"));
        }
        super(false);
        this.setOpaque(false);
        this.setBorder(null);
        this.add(comp);
    }

    @Nullable
    private Component getComponent() {
        if (this.getComponentCount() != 1) {
            return null;
        }
        return this.getComponent(0);
    }

    @Override
    public void doLayout() {
        Component c = this.getComponent();
        if (c == null) {
            return;
        }
        Dimension compSize = c.getPreferredSize();
        Dimension size = this.getSize();
        Pair<Integer, Integer> x = Centerizer.getFit(compSize.width, size.width);
        Pair<Integer, Integer> y = Centerizer.getFit(compSize.height, size.height);
        c.setBounds((Integer)x.first, (Integer)y.first, (Integer)x.second, (Integer)y.second);
    }

    private static Pair<Integer, Integer> getFit(int compSize, int containerSize) {
        if (compSize >= containerSize) {
            return new Pair<Integer, Integer>(0, compSize);
        }
        int position = containerSize / 2 - compSize / 2;
        return new Pair<Integer, Integer>(position, compSize);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getComponent() != null ? this.getComponent().getPreferredSize() : super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getComponent() != null ? this.getComponent().getMinimumSize() : super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getComponent() != null ? this.getComponent().getMaximumSize() : super.getPreferredSize();
    }
}

