/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import sun.reflect.ConstructorAccessor;

public class StringFactory {
    private static final ConstructorAccessor ourConstructorAccessor;

    @NotNull
    public static String createShared(@NotNull char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/StringFactory", "createShared"));
        }
        if (ourConstructorAccessor != null) {
            String string;
            try {
                string = (String)ourConstructorAccessor.newInstance(new Object[]{chars, Boolean.TRUE});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/StringFactory", "createShared"));
            }
            return string;
        }
        String string = new String(chars);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/StringFactory", "createShared"));
        }
        return string;
    }

    static {
        ConstructorAccessor constructorAccessor = null;
        try {
            Constructor newC = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            newC.setAccessible(true);
            Method accessor = Constructor.class.getDeclaredMethod("acquireConstructorAccessor", new Class[0]);
            accessor.setAccessible(true);
            constructorAccessor = (ConstructorAccessor)accessor.invoke(newC, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ourConstructorAccessor = constructorAccessor;
    }
}

