/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.ImmutableCharSequence;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

public final class ImmutableText
extends ImmutableCharSequence
implements CharArrayExternalizable {
    private static final int BLOCK_SIZE = 64;
    private static final int BLOCK_MASK = -64;
    private final char[] _data;
    private final int _count;
    private final ImmutableText _head;
    private final ImmutableText _tail;
    private static final ImmutableText TRUE = ImmutableText.valueOf("true");
    private static final ImmutableText FALSE = ImmutableText.valueOf("false");
    private static final ImmutableText EMPTY = ImmutableText.valueOf("");
    private volatile InnerLeaf myLastLeaf;

    private ImmutableText(char[] data) {
        this._data = data;
        this._count = data.length;
        this._tail = null;
        this._head = null;
    }

    private ImmutableText(ImmutableText head, ImmutableText tail) {
        this._count = head._count + tail._count;
        this._data = null;
        this._head = head;
        this._tail = tail;
    }

    public static ImmutableText valueOf(@NotNull Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/ImmutableText", "valueOf"));
        }
        if (obj instanceof ImmutableText) {
            return (ImmutableText)obj;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0 ? EMPTY : ImmutableText.valueOf((CharSequence)obj);
        }
        return ImmutableText.valueOf(String.valueOf(obj));
    }

    private static ImmutableText valueOf(@NotNull CharSequence str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/ImmutableText", "valueOf"));
        }
        return ImmutableText.valueOf(str, 0, str.length());
    }

    private static ImmutableText valueOf(@NotNull CharSequence str, int start, int end) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/ImmutableText", "valueOf"));
        }
        int length = end - start;
        if (length <= 64) {
            return new ImmutableText(CharArrayUtil.fromSequence(str, start, end));
        }
        int half = length + 64 >> 1 & 0xFFFFFFC0;
        return new ImmutableText(ImmutableText.valueOf(str, start, start + half), ImmutableText.valueOf(str, start + half, end));
    }

    public static ImmutableText valueOf(@NotNull char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/ImmutableText", "valueOf"));
        }
        return ImmutableText.valueOf(chars, 0, chars.length);
    }

    public static ImmutableText valueOf(@NotNull char[] chars, int offset, int length) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/ImmutableText", "valueOf"));
        }
        if (offset < 0 || length < 0 || offset + length > chars.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length <= 64) {
            if (offset == 0 && length == chars.length) {
                return new ImmutableText(chars);
            }
            char[] subArray = new char[length];
            System.arraycopy(chars, offset, subArray, 0, length);
            return new ImmutableText(subArray);
        }
        int half = length + 64 >> 1 & 0xFFFFFFC0;
        return new ImmutableText(ImmutableText.valueOf(chars, offset, half), ImmutableText.valueOf(chars, offset + half, length - half));
    }

    public static ImmutableText valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public int length() {
        return this._count;
    }

    public ImmutableText plus(Object obj) {
        return this.concat(ImmutableText.valueOf(obj));
    }

    public ImmutableText plus(String str) {
        ImmutableText merge = this.append(str);
        return merge != null ? merge : this.concat(ImmutableText.valueOf(str));
    }

    private ImmutableText append(String str) {
        int length = str.length();
        if (this._data == null) {
            ImmutableText merge = this._tail.append(str);
            return merge != null ? new ImmutableText(this._head, merge) : null;
        }
        if (this._count + length > 64) {
            return null;
        }
        char[] chars = new char[this._count + length];
        System.arraycopy(this._data, 0, chars, 0, this._count);
        str.getChars(0, length, chars, this._count);
        return new ImmutableText(chars);
    }

    public ImmutableText concat(ImmutableText that) {
        if (that.length() == 0) {
            return this;
        }
        int length = this._count + that._count;
        if (length <= 64) {
            char[] chars = new char[length];
            this.getChars(0, this._count, chars, 0);
            that.getChars(0, that._count, chars, this._count);
            return new ImmutableText(chars);
        }
        ImmutableText head = this;
        ImmutableText tail = that;
        if (head._count << 1 < tail._count && tail._data == null) {
            if (tail._head._count > tail._tail._count) {
                tail = tail.rightRotation();
            }
            head = head.concat(tail._head);
            tail = tail._tail;
        } else if (tail._count << 1 < head._count && head._data == null) {
            if (head._tail._count > head._head._count) {
                head = head.leftRotation();
            }
            tail = head._tail.concat(tail);
            head = head._head;
        }
        return new ImmutableText(head, tail);
    }

    private ImmutableText rightRotation() {
        ImmutableText P = this._head;
        if (P._data != null) {
            return this;
        }
        ImmutableText A = P._head;
        ImmutableText B = P._tail;
        ImmutableText C = this._tail;
        return new ImmutableText(A, new ImmutableText(B, C));
    }

    private ImmutableText leftRotation() {
        ImmutableText Q = this._tail;
        if (Q._data != null) {
            return this;
        }
        ImmutableText B = Q._head;
        ImmutableText C = Q._tail;
        ImmutableText A = this._head;
        return new ImmutableText(new ImmutableText(A, B), C);
    }

    public ImmutableText subtext(int start) {
        return this.subtext(start, this.length());
    }

    public ImmutableText insert(int index, ImmutableText txt) {
        return this.subtext(0, index).concat(txt).concat(this.subtext(index));
    }

    public ImmutableText insert(int index, CharSequence seq) {
        return this.insert(index, ImmutableText.valueOf(seq));
    }

    public ImmutableText delete(int start, int end) {
        if (start == end) {
            return this;
        }
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
        return this.subtext(0, start).concat(this.subtext(end));
    }

    public ImmutableText replace(CharSequence target, CharSequence replacement) {
        int i = this.indexOf(target);
        return i < 0 ? this : this.subtext(0, i).concat(ImmutableText.valueOf(replacement)).concat(this.subtext(i + target.length()).replace(target, replacement));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return new CharSequenceSubSequence(this, start, end);
    }

    public int indexOf(CharSequence csq) {
        return this.indexOf(csq, 0);
    }

    public int indexOf(CharSequence csq, int fromIndex) {
        int csqLength = csq.length();
        int min = Math.max(0, fromIndex);
        int max = this._count - csqLength;
        if (csqLength == 0) {
            return min > max ? -1 : min;
        }
        char c = csq.charAt(0);
        int i = this.indexOf(c, min);
        while (i >= 0 && i <= max) {
            boolean match = true;
            for (int j = 1; j < csqLength; ++j) {
                if (this.charAt(i + j) == csq.charAt(j)) continue;
                match = false;
                break;
            }
            if (match) {
                return i;
            }
            ++i;
            i = this.indexOf(c, i);
        }
        return -1;
    }

    public int lastIndexOf(CharSequence csq) {
        return this.lastIndexOf(csq, this._count);
    }

    public int lastIndexOf(CharSequence csq, int fromIndex) {
        int csqLength = csq.length();
        boolean min = false;
        int max = Math.min(fromIndex, this._count - csqLength);
        if (csqLength == 0) {
            return 0 > max ? -1 : max;
        }
        char c = csq.charAt(0);
        int i = this.lastIndexOf(c, max);
        while (i >= 0) {
            boolean match = true;
            for (int j = 1; j < csqLength; ++j) {
                if (this.charAt(i + j) == csq.charAt(j)) continue;
                match = false;
                break;
            }
            if (match) {
                return i;
            }
            --i;
            i = this.lastIndexOf(c, i);
        }
        return -1;
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(CharSequence suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }

    public boolean startsWith(CharSequence prefix, int index) {
        int prefixLength = prefix.length();
        if (index >= 0 && index <= this.length() - prefixLength) {
            int i = 0;
            int j = index;
            while (i < prefixLength) {
                if (prefix.charAt(i++) == this.charAt(j++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ImmutableText trim() {
        int first;
        int last = this.length() - 1;
        for (first = 0; first <= last && this.charAt(first) <= ' '; ++first) {
        }
        while (last >= first && this.charAt(last) <= ' ') {
            --last;
        }
        return this.subtext(first, last + 1);
    }

    public boolean contentEquals(CharSequence csq) {
        if (csq.length() != this._count) {
            return false;
        }
        int i = 0;
        while (i < this._count) {
            if (this.charAt(i) == csq.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutableText)) {
            return false;
        }
        ImmutableText that = (ImmutableText)obj;
        if (this._count != that._count) {
            return false;
        }
        int i = 0;
        while (i < this._count) {
            if (this.charAt(i) == that.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        int length = this.length();
        int i = 0;
        while (i < length) {
            h = 31 * h + this.charAt(i++);
        }
        return h;
    }

    public void printStatistics(PrintStream out) {
        int length = this.length();
        int leaves = this.getNbrOfLeaves();
        out.print("LENGTH: " + this.length());
        out.print(", MAX DEPTH: " + this.getDepth());
        out.print(", NBR OF BRANCHES: " + this.getNbrOfBranches());
        out.print(", NBR OF LEAVES: " + leaves);
        out.print(", AVG LEAVE LENGTH: " + (length + (leaves >> 1)) / leaves);
        out.println();
    }

    private int getDepth() {
        if (this._data != null) {
            return 0;
        }
        return Math.max(this._head.getDepth(), this._tail.getDepth()) + 1;
    }

    private int getNbrOfBranches() {
        return this._data == null ? this._head.getNbrOfBranches() + this._tail.getNbrOfBranches() + 1 : 0;
    }

    private int getNbrOfLeaves() {
        return this._data == null ? this._head.getNbrOfLeaves() + this._tail.getNbrOfLeaves() : 1;
    }

    public void print(Writer writer) throws IOException {
        if (this._data != null) {
            writer.write(this._data, 0, this._count);
        } else {
            this._head.print(writer);
            this._tail.print(writer);
        }
    }

    public void println(Writer writer) throws IOException {
        this.print(writer);
        writer.write(10);
    }

    @Override
    public char charAt(int index) {
        InnerLeaf leaf = this.myLastLeaf;
        if (leaf == null || index < leaf.offset || index >= leaf.offset + leaf.leafText._count) {
            this.myLastLeaf = leaf = this.findLeaf(index, 0);
        }
        return leaf.leafText._data[index - leaf.offset];
    }

    private InnerLeaf findLeaf(int index, int offset) {
        ImmutableText node = this;
        while (true) {
            if (index >= node._count) {
                throw new IndexOutOfBoundsException();
            }
            if (node._data != null) {
                return new InnerLeaf(node, offset);
            }
            if (index < node._head._count) {
                node = node._head;
                continue;
            }
            offset += node._head._count;
            index -= node._head._count;
            node = node._tail;
        }
    }

    public int indexOf(char c, int fromIndex) {
        int headIndex;
        if (this._data != null) {
            for (int i = Math.max(fromIndex, 0); i < this._count; ++i) {
                if (this._data[i] != c) continue;
                return i;
            }
            return -1;
        }
        int cesure = this._head._count;
        if (fromIndex < cesure && (headIndex = this._head.indexOf(c, fromIndex)) >= 0) {
            return headIndex;
        }
        int tailIndex = this._tail.indexOf(c, fromIndex - cesure);
        return tailIndex >= 0 ? tailIndex + cesure : -1;
    }

    public int lastIndexOf(char c, int fromIndex) {
        int tailIndex;
        if (this._data != null) {
            for (int i = Math.min(fromIndex, this._count - 1); i >= 0; --i) {
                if (this._data[i] != c) continue;
                return i;
            }
            return -1;
        }
        int cesure = this._head._count;
        if (fromIndex >= cesure && (tailIndex = this._tail.lastIndexOf(c, fromIndex - cesure)) >= 0) {
            return tailIndex + cesure;
        }
        return this._head.lastIndexOf(c, fromIndex);
    }

    public ImmutableText subtext(int start, int end) {
        if (this._data != null) {
            if (start < 0 || start > end || end > this._count) {
                throw new IndexOutOfBoundsException();
            }
            if (start == 0 && end == this._count) {
                return this;
            }
            if (start == end) {
                return EMPTY;
            }
            int length = end - start;
            char[] chars = new char[length];
            System.arraycopy(this._data, start, chars, 0, length);
            return new ImmutableText(chars);
        }
        int cesure = this._head._count;
        if (end <= cesure) {
            return this._head.subtext(start, end);
        }
        if (start >= cesure) {
            return this._tail.subtext(start - cesure, end - cesure);
        }
        if (start == 0 && end == this._count) {
            return this;
        }
        return this._head.subtext(start, cesure).concat(this._tail.subtext(0, end - cesure));
    }

    @Override
    public void getChars(int start, int end, @NotNull char[] dest, int destPos) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/text/ImmutableText", "getChars"));
        }
        if (this._data != null) {
            if (start < 0 || end > this._count || start > end) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(this._data, start, dest, destPos, end - start);
        } else {
            int cesure = this._head._count;
            if (end <= cesure) {
                this._head.getChars(start, end, dest, destPos);
            } else if (start >= cesure) {
                this._tail.getChars(start - cesure, end - cesure, dest, destPos);
            } else {
                this._head.getChars(start, cesure, dest, destPos);
                this._tail.getChars(0, end - cesure, dest, destPos + cesure - start);
            }
        }
    }

    @Override
    @NotNull
    public String toString() {
        if (this._data != null) {
            String string = new String(this._data, 0, this._count);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ImmutableText", "toString"));
            }
            return string;
        }
        char[] data = new char[this._count];
        this.getChars(0, this._count, data, 0);
        String string = new String(data, 0, this._count);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ImmutableText", "toString"));
        }
        return string;
    }

    private static class InnerLeaf {
        final ImmutableText leafText;
        final int offset;

        private InnerLeaf(ImmutableText leafText, int offset) {
            this.leafText = leafText;
            this.offset = offset;
        }
    }
}

