/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;

public class CharSequenceSubSequence
implements CharSequence {
    private final CharSequence myChars;
    private final int myStart;
    private final int myEnd;

    public CharSequenceSubSequence(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharSequenceSubSequence", "<init>"));
        }
        this(chars, 0, chars.length());
    }

    public CharSequenceSubSequence(@NotNull CharSequence chars, int start, int end) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/CharSequenceSubSequence", "<init>"));
        }
        if (start < 0 || end > chars.length() || start > end) {
            throw new IndexOutOfBoundsException("chars sequence.length:" + chars.length() + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return this.myChars.charAt(index + this.myStart);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == this.myStart && end == this.myEnd) {
            return this;
        }
        return new CharSequenceSubSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.myChars instanceof String) {
            String string = ((String)this.myChars).substring(this.myStart, this.myEnd);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharSequenceSubSequence", "toString"));
            }
            return string;
        }
        String string = StringFactory.createShared(CharArrayUtil.fromSequence(this.myChars, this.myStart, this.myEnd));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharSequenceSubSequence", "toString"));
        }
        return string;
    }

    public CharSequence getBaseSequence() {
        return this.myChars;
    }
}

