/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompoundRuntimeException
extends RuntimeException {
    private final List<Throwable> myThrowables;

    public CompoundRuntimeException(List<Throwable> throwables) {
        super("Several Exceptions occured", throwables.get(0));
        this.myThrowables = throwables;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        for (Throwable throwable : this.myThrowables) {
            throwable.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        for (Throwable throwable : this.myThrowables) {
            throwable.printStackTrace(s);
        }
    }

    public static void doThrow(@NotNull List<Throwable> throwables) {
        if (throwables == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/lang/CompoundRuntimeException", "doThrow"));
        }
        if (throwables.size() == 1) {
            Throwable throwable = throwables.get(0);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
        }
        throw new CompoundRuntimeException(throwables);
    }
}

