/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.MapBackedFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import org.jetbrains.annotations.NotNull;

class ArrayBackedFMap
implements KeyFMap {
    static final int ARRAY_THRESHOLD = 8;
    private final int[] keys;
    private final Object[] values;

    ArrayBackedFMap(@NotNull int[] keys, @NotNull Object[] values) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/keyFMap/ArrayBackedFMap", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/keyFMap/ArrayBackedFMap", "<init>"));
        }
        this.keys = keys;
        this.values = values;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        int i;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
        }
        int oldSize = this.size();
        int keyCode = key.hashCode();
        int[] newKeys = null;
        Object[] newValues = null;
        for (i = 0; i < oldSize; ++i) {
            int oldKey = this.keys[i];
            if (keyCode != oldKey) continue;
            if (value == this.values[i]) {
                ArrayBackedFMap arrayBackedFMap = this;
                if (arrayBackedFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
                }
                return arrayBackedFMap;
            }
            newKeys = new int[oldSize];
            newValues = new Object[oldSize];
            System.arraycopy(this.keys, 0, newKeys, 0, oldSize);
            System.arraycopy(this.values, 0, newValues, 0, oldSize);
            newValues[i] = value;
            break;
        }
        if (i == oldSize) {
            if (oldSize == 8) {
                MapBackedFMap mapBackedFMap = new MapBackedFMap(this.keys, keyCode, this.values, value);
                if (mapBackedFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
                }
                return mapBackedFMap;
            }
            int newSize = oldSize + 1;
            newKeys = new int[newSize];
            newValues = new Object[newSize];
            System.arraycopy(this.keys, 0, newKeys, 0, oldSize);
            System.arraycopy(this.values, 0, newValues, 0, oldSize);
            newKeys[oldSize] = keyCode;
            newValues[oldSize] = value;
        }
        ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(newKeys, newValues);
        if (arrayBackedFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
        }
        return arrayBackedFMap;
    }

    private int size() {
        return this.keys.length;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
        }
        int oldSize = this.size();
        int keyCode = key.hashCode();
        for (int i = 0; i < oldSize; ++i) {
            int oldKey = this.keys[i];
            if (keyCode != oldKey) continue;
            if (oldSize == 3) {
                int i1 = (2 - i) / 2;
                int i2 = 3 - (i + 2) / 2;
                PairElementsFMap pairElementsFMap = new PairElementsFMap(this.keys[i1], this.values[i1], this.keys[i2], this.values[i2]);
                if (pairElementsFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
                }
                return pairElementsFMap;
            }
            int newSize = oldSize - 1;
            int[] newKeys = new int[newSize];
            Object[] newValues = new Object[newSize];
            System.arraycopy(this.keys, 0, newKeys, 0, i);
            System.arraycopy(this.values, 0, newValues, 0, i);
            System.arraycopy(this.keys, i + 1, newKeys, i, oldSize - i - 1);
            System.arraycopy(this.values, i + 1, newValues, i, oldSize - i - 1);
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(newKeys, newValues);
            if (arrayBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
            }
            return arrayBackedFMap;
        }
        ArrayBackedFMap arrayBackedFMap = this;
        if (arrayBackedFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
        }
        return arrayBackedFMap;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/keyFMap/ArrayBackedFMap", "get"));
        }
        int oldSize = this.size();
        int keyCode = key.hashCode();
        for (int i = 0; i < oldSize; ++i) {
            int oldKey = this.keys[i];
            if (keyCode != oldKey) continue;
            return (V)this.values[i];
        }
        return null;
    }

    @Override
    public String toString() {
        String s = "";
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            Object value = this.values[i];
            s = s + (s.isEmpty() ? "" : ", ") + Key.getKeyByIndex(key) + " -> " + value;
        }
        return "(" + s + ")";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

