/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.reference.SoftReference;
import com.intellij.util.SystemProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IOUtil {
    public static final boolean ourByteBuffersUseNativeByteOrder = SystemProperties.getBooleanProperty("idea.bytebuffers.use.native.byte.order", true);
    private static final int STRING_HEADER_SIZE = 1;
    private static final int STRING_LENGTH_THRESHOLD = 255;
    @NonNls
    private static final String LONGER_THAN_64K_MARKER = "LONGER_THAN_64K";
    private static final ThreadLocal<SoftReference<byte[]>> ourReadWriteBuffersCache = new ThreadLocal();
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final ThreadLocal<SoftReference<char[]>> spareBufferLocal = new ThreadLocal();

    private IOUtil() {
    }

    public static String readString(@NotNull DataInput stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/IOUtil", "readString"));
        }
        int length = stream.readInt();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length * 2];
        stream.readFully(bytes);
        return new String(bytes, 0, length * 2, CharsetToolkit.UTF_16BE_CHARSET);
    }

    public static void writeString(String s, @NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/io/IOUtil", "writeString"));
        }
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(s.length());
        if (s.isEmpty()) {
            return;
        }
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        int i = 0;
        int i2 = 0;
        while (i < chars.length) {
            char aChar = chars[i];
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    public static void writeUTFTruncated(@NotNull DataOutput stream, @NotNull String text) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/IOUtil", "writeUTFTruncated"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/io/IOUtil", "writeUTFTruncated"));
        }
        if (text.length() > 16383) {
            stream.writeUTF(text.substring(0, 16383));
        } else {
            stream.writeUTF(text);
        }
    }

    public static void writeUTF(@NotNull DataOutput storage, @NotNull String value) throws IOException {
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/IOUtil", "writeUTF"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/io/IOUtil", "writeUTF"));
        }
        IOUtil.writeUTFFast(IOUtil.getThreadLocalOrCreateReadWriteUTFBuffer(), storage, value);
    }

    public static String readUTF(@NotNull DataInput storage) throws IOException {
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/IOUtil", "readUTF"));
        }
        return IOUtil.readUTFFast(IOUtil.getThreadLocalOrCreateReadWriteUTFBuffer(), storage);
    }

    private static byte[] getThreadLocalOrCreateReadWriteUTFBuffer() {
        byte[] buffer = (byte[])SoftReference.dereference(ourReadWriteBuffersCache.get());
        if (buffer == null) {
            buffer = IOUtil.allocReadWriteUTFBuffer();
            ourReadWriteBuffersCache.set(new SoftReference<byte[]>(buffer));
        }
        return buffer;
    }

    @NotNull
    public static byte[] allocReadWriteUTFBuffer() {
        byte[] byArray = new byte[256];
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/IOUtil", "allocReadWriteUTFBuffer"));
        }
        return byArray;
    }

    public static void writeUTFFast(@NotNull byte[] buffer, @NotNull DataOutput storage, @NotNull String value) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/IOUtil", "writeUTFFast"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/io/IOUtil", "writeUTFFast"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/io/IOUtil", "writeUTFFast"));
        }
        int len = value.length();
        if (len < 255) {
            buffer[0] = (byte)len;
            boolean isAscii = true;
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c >= '\u0080') {
                    isAscii = false;
                    break;
                }
                buffer[i + 1] = (byte)c;
            }
            if (isAscii) {
                storage.write(buffer, 0, len + 1);
                return;
            }
        }
        storage.writeByte(-1);
        try {
            storage.writeUTF(value);
        }
        catch (UTFDataFormatException e) {
            storage.writeUTF(LONGER_THAN_64K_MARKER);
            IOUtil.writeString(value, storage);
        }
    }

    public static String readUTFFast(@NotNull byte[] buffer, @NotNull DataInput storage) throws IOException {
        char[] chars;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/IOUtil", "readUTFFast"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/io/IOUtil", "readUTFFast"));
        }
        int len = 0xFF & storage.readByte();
        if (len == 255) {
            String result = storage.readUTF();
            if (LONGER_THAN_64K_MARKER.equals(result)) {
                return IOUtil.readString(storage);
            }
            return result;
        }
        if (len == 0) {
            return "";
        }
        storage.readFully(buffer, 0, len);
        SoftReference<char[]> reference = spareBufferLocal.get();
        char[] cArray = chars = reference != null ? (char[])reference.get() : null;
        if (chars == null) {
            chars = new char[255];
            spareBufferLocal.set(new SoftReference<char[]>(chars));
        }
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(buffer[i] & 0xFF);
        }
        return new String(chars, 0, len);
    }

    public static boolean isAscii(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/IOUtil", "isAscii"));
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(char c) {
        return c < '\u0080';
    }

    public static boolean deleteAllFilesStartingWith(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/IOUtil", "deleteAllFilesStartingWith"));
        }
        final String baseName = file.getName();
        File parentFile = file.getParentFile();
        File[] files = parentFile != null ? parentFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(baseName);
            }
        }) : null;
        boolean ok = true;
        if (files != null) {
            for (File f : files) {
                ok &= FileUtil.delete(f);
            }
        }
        return ok;
    }

    public static void syncStream(OutputStream stream) throws IOException {
        stream.flush();
        try {
            Object o;
            Field outField = FilterOutputStream.class.getDeclaredField("out");
            outField.setAccessible(true);
            while (stream instanceof FilterOutputStream && (o = outField.get(stream)) instanceof OutputStream) {
                stream = (OutputStream)o;
            }
            if (stream instanceof FileOutputStream) {
                ((FileOutputStream)stream).getFD().sync();
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, IOException> factoryComputable, final File file) throws IOException {
        if (factoryComputable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/IOUtil", "openCleanOrResetBroken"));
        }
        return IOUtil.openCleanOrResetBroken(factoryComputable, new Runnable(){

            @Override
            public void run() {
                IOUtil.deleteAllFilesStartingWith(file);
            }
        });
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, IOException> factoryComputable, Runnable cleanupCallback) throws IOException {
        if (factoryComputable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/IOUtil", "openCleanOrResetBroken"));
        }
        for (int i = 0; i < 2; ++i) {
            try {
                return factoryComputable.compute();
            }
            catch (IOException ex) {
                if (i == 1) {
                    throw ex;
                }
                cleanupCallback.run();
                continue;
            }
        }
        return null;
    }
}

