/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.BaseDataReader;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

public abstract class BaseOutputReader
extends BaseDataReader {
    protected final Reader myReader;
    private final char[] myBuffer;
    private final StringBuilder myTextBuffer;
    private boolean skipLF;

    public BaseOutputReader(@NotNull Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        this(reader, null);
    }

    public BaseOutputReader(@NotNull Reader reader, BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        super(sleepingPolicy);
        this.myBuffer = new char[8192];
        this.myTextBuffer = new StringBuilder();
        this.skipLF = false;
        this.myReader = reader;
    }

    @Override
    protected final boolean readAvailable() throws IOException {
        int n;
        char[] buffer = this.myBuffer;
        StringBuilder token = this.myTextBuffer;
        token.setLength(0);
        boolean read = false;
        while (this.myReader.ready() && (n = this.myReader.read(buffer)) > 0) {
            read = true;
            for (int i = 0; i < n; ++i) {
                char c = buffer[i];
                if (this.skipLF && c != '\n') {
                    token.append('\r');
                }
                if (c == '\r') {
                    this.skipLF = true;
                } else {
                    this.skipLF = false;
                    token.append(c);
                }
                if (c != '\n') continue;
                this.onTextAvailable(token.toString());
                token.setLength(0);
            }
        }
        if (token.length() != 0) {
            this.onTextAvailable(token.toString());
            token.setLength(0);
        }
        return read;
    }

    @Override
    protected void close() throws IOException {
        this.myReader.close();
    }

    protected abstract void onTextAvailable(@NotNull String var1);
}

