/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SoftHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SoftArrayHashMap<T, V>
implements Cloneable {
    private SoftHashMap<T, SoftArrayHashMap<T, V>> myContinuationMap;
    private SoftHashMap<T, V> myValuesMap;
    private V myEmptyValue;
    private final TObjectHashingStrategy<T> myStrategy;

    public SoftArrayHashMap() {
        this(ContainerUtil.canonicalStrategy());
    }

    public SoftArrayHashMap(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/SoftArrayHashMap", "<init>"));
        }
        this.myStrategy = strategy;
    }

    private V get(T[] array, int index) {
        SoftArrayHashMap map;
        if (index == array.length - 1) {
            return (V)(this.myValuesMap != null ? this.myValuesMap.get(array[index]) : null);
        }
        if (this.myContinuationMap != null && (map = (SoftArrayHashMap)this.myContinuationMap.get(array[index])) != null) {
            return map.get(array, index + 1);
        }
        return null;
    }

    public final V get(T[] key) {
        if (key.length == 0) {
            return this.myEmptyValue;
        }
        return this.get(key, 0);
    }

    public boolean processLeafEntries(PairProcessor<T, V> processor) {
        if (this.myValuesMap != null) {
            for (Object t : this.myValuesMap.keySet()) {
                if (processor.process(t, this.myValuesMap.get(t))) continue;
                return false;
            }
        }
        if (this.myContinuationMap != null) {
            for (SoftArrayHashMap map : this.myContinuationMap.values()) {
                if (map.processLeafEntries(processor)) continue;
                return false;
            }
        }
        return true;
    }

    private void put(T[] array, int index, V value) {
        T key = array[index];
        if (index == array.length - 1) {
            if (this.myValuesMap == null) {
                this.myValuesMap = new SoftHashMap(this.myStrategy);
            }
            this.myValuesMap.put((Object)key, (Object)value);
        } else {
            SoftArrayHashMap<T, V> softArrayHashMap;
            if (this.myContinuationMap == null) {
                this.myContinuationMap = new SoftHashMap(this.myStrategy);
            }
            if ((softArrayHashMap = (SoftArrayHashMap<T, V>)this.myContinuationMap.get(key)) == null) {
                softArrayHashMap = new SoftArrayHashMap<T, V>(this.myStrategy);
                this.myContinuationMap.put((Object)key, (Object)softArrayHashMap);
            }
            softArrayHashMap.put(array, index + 1, value);
        }
    }

    public final void put(T[] key, V value) {
        if (key.length == 0) {
            this.myEmptyValue = value;
        } else {
            this.put(key, 0, value);
        }
    }

    public final void clear() {
        this.myContinuationMap = null;
        this.myValuesMap = null;
        this.myEmptyValue = null;
    }

    public final boolean containsKey(T[] path) {
        return this.get(path) != null;
    }

    public final SoftArrayHashMap<T, V> clone() {
        SoftArrayHashMap<T, V> copy = new SoftArrayHashMap<T, V>(this.myStrategy);
        copy.myContinuationMap = this.copyMap(this.myContinuationMap);
        copy.myValuesMap = this.copyMap(this.myValuesMap);
        copy.myEmptyValue = this.myEmptyValue;
        return copy;
    }

    private <X> SoftHashMap<T, X> copyMap(SoftHashMap<T, X> map) {
        SoftHashMap copy = new SoftHashMap();
        for (Map.Entry entry : map.entrySet()) {
            copy.put(entry.getKey(), entry.getValue());
        }
        return copy;
    }
}

