/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.SmartList;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiMap<K, V>
implements Serializable {
    public static final MultiMap EMPTY = new EmptyMap();
    private static final long serialVersionUID = -2632269270151455493L;
    protected final Map<K, Collection<V>> myMap;
    private Collection<V> values;

    public MultiMap() {
        this.myMap = this.createMap();
    }

    public MultiMap(MultiMap<? extends K, ? extends V> toCopy) {
        this();
        this.putAllValues(toCopy);
    }

    public MultiMap(int i, float v) {
        this.myMap = this.createMap(i, v);
    }

    protected Map<K, Collection<V>> createMap() {
        return new HashMap();
    }

    protected Map<K, Collection<V>> createMap(int initialCapacity, float loadFactor) {
        return new HashMap(initialCapacity, loadFactor);
    }

    protected Collection<V> createCollection() {
        return new ArrayList();
    }

    protected Collection<V> createEmptyCollection() {
        return Collections.emptyList();
    }

    public <Kk extends K, Vv extends V> void putAllValues(MultiMap<Kk, Vv> from) {
        for (Map.Entry<Kk, Collection<Vv>> entry : from.entrySet()) {
            this.putValues(entry.getKey(), entry.getValue());
        }
    }

    public void putValues(K key, Collection<? extends V> values) {
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.addAll(values);
    }

    public void putValue(@Nullable K key, V value) {
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.add(value);
    }

    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.myMap.entrySet();
    }

    public boolean isEmpty() {
        if (this.myMap.isEmpty()) {
            return true;
        }
        for (Collection<V> valueList : this.myMap.values()) {
            if (valueList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    public boolean containsScalarValue(V value) {
        for (Collection<V> valueList : this.myMap.values()) {
            if (!valueList.contains(value)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<V> get(K key) {
        Collection<V> collection = this.myMap.get(key);
        Collection<V> collection2 = collection == null ? this.createEmptyCollection() : collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "get"));
        }
        return collection2;
    }

    @NotNull
    public Collection<V> getModifiable(K key) {
        Collection<V> collection = this.myMap.get(key);
        if (collection == null) {
            collection = this.createCollection();
            this.myMap.put(key, collection);
        }
        Collection<V> collection2 = collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "getModifiable"));
        }
        return collection2;
    }

    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    public int size() {
        return this.myMap.size();
    }

    public void put(K key, Collection<V> values) {
        this.myMap.put(key, values);
    }

    public void removeValue(K key, V value) {
        this.remove(key, value);
    }

    public boolean remove(K key, V value) {
        Collection<V> values = this.myMap.get(key);
        if (values != null) {
            boolean removed = values.remove(value);
            if (values.isEmpty()) {
                this.myMap.remove(key);
            }
            return removed;
        }
        return false;
    }

    public Collection<? extends V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                @NotNull
                public Iterator<V> iterator() {
                    Iterator iterator = new Iterator<V>(){
                        private final Iterator<Collection<V>> mapIterator;
                        private Iterator<V> itr;
                        {
                            this.mapIterator = MultiMap.this.myMap.values().iterator();
                            this.itr = EmptyIterator.getInstance();
                        }

                        @Override
                        public boolean hasNext() {
                            while (!this.itr.hasNext()) {
                                if (!this.mapIterator.hasNext()) {
                                    return false;
                                }
                                this.itr = this.mapIterator.next().iterator();
                            }
                            return true;
                        }

                        @Override
                        public V next() {
                            while (!this.itr.hasNext()) {
                                if (!this.mapIterator.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                this.itr = this.mapIterator.next().iterator();
                            }
                            return this.itr.next();
                        }

                        @Override
                        public void remove() {
                            this.itr.remove();
                        }
                    };
                    if (iterator == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$1", "iterator"));
                    }
                    return iterator;
                }

                @Override
                public int size() {
                    int res = 0;
                    for (Collection vs : MultiMap.this.myMap.values()) {
                        res += vs.size();
                    }
                    return res;
                }

                @Override
                public boolean contains(Object o) {
                    for (Collection vs : MultiMap.this.myMap.values()) {
                        if (!vs.contains(o)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.values;
    }

    public void clear() {
        this.myMap.clear();
    }

    public Collection<V> remove(K key) {
        return this.myMap.remove(key);
    }

    @NotNull
    public static <K, V> MultiMap<K, V> emptyInstance() {
        MultiMap empty;
        MultiMap multiMap = empty = EMPTY;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "emptyInstance"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create() {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "create"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create(final @NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/MultiMap", "create"));
        }
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            protected Map<K, Collection<V>> createMap() {
                return new THashMap(strategy);
            }

            @Override
            protected Collection<V> createCollection() {
                return new SmartList();
            }
        };
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "create"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinked() {
        LinkedMultiMap linkedMultiMap = new LinkedMultiMap();
        if (linkedMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createLinked"));
        }
        return linkedMultiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSmartList() {
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            protected Collection<V> createCollection() {
                return new SmartList();
            }

            @Override
            protected Map<K, Collection<V>> createMap() {
                return new THashMap();
            }
        };
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createSmartList"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet() {
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            protected Collection<V> createCollection() {
                return new SmartHashSet();
            }

            @Override
            protected Collection<V> createEmptyCollection() {
                return Collections.emptySet();
            }

            @Override
            protected Map<K, Collection<V>> createMap() {
                return new THashMap();
            }
        };
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createSet"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create(int i, float v) {
        MultiMap<K, V> multiMap = new MultiMap<K, V>(i, v);
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "create"));
        }
        return multiMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiMap)) {
            return false;
        }
        return ((Object)this.myMap).equals(((MultiMap)o).myMap);
    }

    public int hashCode() {
        return ((Object)this.myMap).hashCode();
    }

    public String toString() {
        return this.myMap.toString();
    }

    private static class EmptyMap
    extends MultiMap {
        private EmptyMap() {
        }

        protected Map createMap() {
            return Collections.emptyMap();
        }
    }
}

