/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public abstract class ImmutableUserMap {
    public static final ImmutableUserMap EMPTY = new ImmutableUserMap(){

        @Override
        public <T> T get(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ImmutableUserMap$1", "get"));
            }
            return null;
        }
    };

    private ImmutableUserMap() {
    }

    public abstract <T> T get(@NotNull Key<T> var1);

    public final <T> ImmutableUserMap put(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ImmutableUserMap", "put"));
        }
        return new ImmutableUserMapImpl(key, value, this);
    }

    private static class ImmutableUserMapImpl<V>
    extends ImmutableUserMap {
        private final Key<V> myKey;
        private final V myValue;
        private final ImmutableUserMap myNext;

        private ImmutableUserMapImpl(Key<V> key, V value, ImmutableUserMap next) {
            this.myKey = key;
            this.myNext = next;
            this.myValue = value;
        }

        @Override
        public <T> T get(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ImmutableUserMap$ImmutableUserMapImpl", "get"));
            }
            if (key.equals(this.myKey)) {
                return (T)this.myValue;
            }
            return this.myNext.get(key);
        }
    }
}

