/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FactoryMap<K, V>
implements Map<K, V> {
    protected Map<K, V> myMap;

    protected Map<K, V> createMap() {
        return new THashMap();
    }

    @Nullable
    protected abstract V create(K var1);

    private Map<K, V> getMap() {
        if (this.myMap == null) {
            this.myMap = this.createMap();
        }
        return this.myMap;
    }

    @Override
    public V get(Object key) {
        Map<Object, Object> map = this.getMap();
        V value = map.get(FactoryMap.getKey(key));
        if (value == null) {
            value = this.create(key);
            map.put(FactoryMap.getKey(key), value == null ? ObjectUtils.NULL : value);
        }
        return value == ObjectUtils.NULL ? null : (V)value;
    }

    private static <K> K getKey(K key) {
        return (K)(key == null ? ObjectUtils.NULL : key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.myMap != null && this.myMap.containsKey(FactoryMap.getKey(key));
    }

    @Override
    public V put(K key, V value) {
        Object v = this.getMap().put(FactoryMap.getKey(key), value == null ? ObjectUtils.NULL : value);
        return (V)(v == ObjectUtils.NULL ? null : v);
    }

    @Override
    public V remove(Object key) {
        if (this.myMap == null) {
            return null;
        }
        V v = this.myMap.remove(key);
        return v == ObjectUtils.NULL ? null : (V)v;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        if (this.myMap == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "keySet"));
            }
            return set;
        }
        Set<K> ts = this.myMap.keySet();
        if (ts.contains(ObjectUtils.NULL)) {
            HashSet<K> hashSet = new HashSet<K>(ts);
            hashSet.remove(ObjectUtils.NULL);
            hashSet.add(null);
            HashSet<K> hashSet2 = hashSet;
            if (hashSet2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "keySet"));
            }
            return hashSet2;
        }
        Set<K> set = ts;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "keySet"));
        }
        return set;
    }

    public Collection<V> notNullValues() {
        if (this.myMap == null) {
            return Collections.emptyList();
        }
        ArrayList<V> values = new ArrayList<V>(this.myMap.values());
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != ObjectUtils.NULL) continue;
            iterator.remove();
        }
        return values;
    }

    @Override
    public void clear() {
        if (this.myMap != null) {
            this.myMap.clear();
        }
    }

    @Override
    public int size() {
        if (this.myMap == null) {
            return 0;
        }
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap == null || this.myMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myMap != null && this.myMap.containsValue(value);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/FactoryMap", "putAll"));
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (this.myMap == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "values"));
            }
            return list;
        }
        Collection<V> collection = this.myMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "values"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.myMap == null) {
            Set<Map.Entry<K, V>> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "entrySet"));
            }
            return set;
        }
        Set<Map.Entry<K, V>> set = this.myMap.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "entrySet"));
        }
        return set;
    }
}

